/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.spi.VersionProvider;
import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.TimeRange;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.model.VisibleValueRangeModel;
import com.azul.log.gui.ui.ContentPanel;
import com.azul.log.gui.ui.RangeSlider;
import com.azul.log.gui.utils.jfreechart.ChartEx;
import com.azul.log.gui.utils.jfreechart.ChartPanelEx;
import com.azul.log.gui.utils.jfreechart.JFreeChartSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.time.TimeSeries;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public final class GraphPanel
extends ContentPanel {
    private final GraphListener graphListener = new GraphListener();
    private final TimeRangeSelectionModel.VisibleTimeRangeModel visibleTimeRangeModel = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
    private final TimeSelectionListener timeSelectionListener = new TimeSelectionListener();
    private final VisibleValueRangeModel visibleValueRangeModel = Context.lookup(VisibleValueRangeModel.class);
    private final ValueRangeSelectionListener visibleValueRangeListener = new ValueRangeSelectionListener();
    private final SelectionListener selectionListener;
    private ChartPanelEx chartPanel;
    private RangeSlider rangeSlider;
    private boolean visibleRangeChangedBySelf = false;
    private final ChartEx mainChart;
    private final ChartEx sliderChart;

    public static GraphPanel create(GraphDefinition gd) {
        TimeSeries[] series = JFreeChartSupport.initTimeSeries(gd);
        ChartEx mainChart = JFreeChartSupport.createXYGraph(gd, series, false, true);
        ChartEx sliderChart = JFreeChartSupport.createXYGraph(gd, series, true, false);
        return new GraphPanel(mainChart, sliderChart);
    }

    private GraphPanel(ChartEx mainChart, ChartEx sliderChart) {
        super(new ProxyLookup(mainChart.getLookup()));
        this.mainChart = mainChart;
        this.sliderChart = sliderChart;
        this.setLayout(new BorderLayout());
        this.addCharts();
        this.selectionListener = new SelectionListener(mainChart);
    }

    private void addCharts() {
        this.chartPanel = new ChartPanelEx(this.mainChart, true, true);
        this.timeSelectionListener.stateChanged(null);
        this.add((Component)this.chartPanel, "Center");
        this.addBottomPanel();
        this.ic.add(() -> this.chartPanel.doSaveAs());
        this.ic.add(() -> this.chartPanel.copyToClipboard());
    }

    private void addBottomPanel() {
        this.rangeSlider = new RangeSlider(this.sliderChart.getChart(), (BoundedRangeModel)((Object)this.visibleTimeRangeModel));
        String versionStr = Lookup.getDefault().lookupAll(VersionProvider.class).stream().map(VersionProvider::getVersion).collect(Collectors.joining("\n"));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        JPanel versionPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(versionStr);
        versionPanel.add((Component)label, "East");
        label.setForeground(Color.GRAY);
        versionPanel.setBackground(Color.WHITE);
        bottomPanel.add(versionPanel);
        bottomPanel.add(this.rangeSlider);
        this.add((Component)bottomPanel, "South");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.installListeners();
    }

    @Override
    public void removeNotify() {
        this.uninstallListeners();
        super.removeNotify();
    }

    private void installListeners() {
        this.visibleTimeRangeModel.addChangeListener(this.timeSelectionListener);
        this.visibleValueRangeModel.addChangeListener(this.visibleValueRangeListener);
        UIElementSelectionModel.getInstance().addChangeListener(this.selectionListener);
        XYPlot plot = this.mainChart.getChart().getXYPlot();
        plot.getDomainAxis().addChangeListener(this.graphListener);
        plot.getRangeAxis().addChangeListener(this.graphListener);
        this.visibleValueRangeListener.stateChanged(null);
    }

    private void uninstallListeners() {
        this.rangeSlider.setModel(new DefaultBoundedRangeModel());
        this.visibleTimeRangeModel.removeChangeListener(this.timeSelectionListener);
        this.visibleValueRangeModel.removeChangeListener(this.visibleValueRangeListener);
        UIElementSelectionModel.getInstance().removeChangeListener(this.selectionListener);
        XYPlot plot = this.mainChart.getChart().getXYPlot();
        plot.getDomainAxis().removeChangeListener(this.graphListener);
        plot.getRangeAxis().removeChangeListener(this.graphListener);
    }

    private static class SelectionListener
    implements ChangeListener {
        private final ChartEx mainChart;

        public SelectionListener(ChartEx mainChart) {
            this.mainChart = mainChart;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.mainChart.getChart().fireChartChanged();
        }
    }

    private class GraphListener
    implements AxisChangeListener {
        private GraphListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void axisChanged(AxisChangeEvent ace) {
            JFreeChart chart = GraphPanel.this.chartPanel.getChart();
            if (chart != null) {
                Range xrange = chart.getXYPlot().getDomainAxis().getRange();
                TimeRange timeRange = JFreeChartSupport.fromJFCRange(xrange, TimeUnit.NANOSECONDS);
                try {
                    GraphPanel.this.visibleRangeChangedBySelf = true;
                    GraphPanel.this.visibleTimeRangeModel.setSelection(timeRange);
                }
                finally {
                    GraphPanel.this.visibleRangeChangedBySelf = false;
                }
                Range yrange = chart.getXYPlot().getRangeAxis().getRange();
                GraphPanel.this.visibleValueRangeModel.setVisibleValueRange(GraphPanel.this.mainChart.getGraphDefinition().getID(), yrange);
            }
        }
    }

    private class TimeSelectionListener
    implements ChangeListener {
        private TimeSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (GraphPanel.this.visibleRangeChangedBySelf) {
                return;
            }
            TimeRange selection = GraphPanel.this.visibleTimeRangeModel.getSelection();
            if (selection.length(TimeUnit.MILLISECONDS) > 10L) {
                Range range = JFreeChartSupport.toJFCRange(selection, TimeUnit.NANOSECONDS);
                JFreeChart chart = GraphPanel.this.chartPanel.getChart();
                if (chart != null) {
                    chart.getXYPlot().getDomainAxis().setRange(range);
                }
            }
            GraphPanel.this.revalidate();
            GraphPanel.this.repaint();
        }
    }

    private class ValueRangeSelectionListener
    implements ChangeListener {
        private ValueRangeSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ValueAxis rangeAxis = GraphPanel.this.mainChart.getChart().getXYPlot().getRangeAxis();
            Range range = GraphPanel.this.visibleValueRangeModel.getVisibleValueRange(GraphPanel.this.mainChart.getGraphDefinition().getID());
            if (range != null) {
                rangeAxis.setRange(range);
            } else {
                rangeAxis.setAutoRange(true);
            }
        }
    }
}

