/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.graphs.api.PlotData;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.TimeRange;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.utils.jfreechart.ChartEx;
import com.azul.log.gui.utils.jfreechart.ChartPanelEx;
import com.azul.log.gui.utils.jfreechart.JFreeChartSupport;
import com.azul.log.model.api.RelativeTimestamp;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public final class GraphPreviewPanel
extends JPanel
implements Lookup.Provider {
    private final Lookup lookup;
    private final ChartPanelEx chartPanel;
    private final TimeRangeSelectionModel.SelectedTimeRangeModel timeRangeSelectionModel;
    private final TimeRangeSelectionListener timeRangeSelectionListener;

    public GraphPreviewPanel() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(100, 100));
        GraphDefinition gd = Optional.ofNullable(Context.lookup(GraphDefinition.class)).orElse(Context.lookup(PlotData.class).getGraphDefinition(0));
        ChartEx chart = JFreeChartSupport.createXYGraph(gd, false, false);
        chart.setTitle(null);
        chart.setRangeAxisLabel(null);
        chart.setDomainAxisLabel(null);
        chart.getChart().addProgressListener(e -> {
            if (2 == e.getType()) {
                this.repaint();
            }
        });
        this.chartPanel = new ChartPanelEx(chart, false, false);
        this.lookup = new ProxyLookup(chart.getLookup(), this.chartPanel.getLookup());
        this.timeRangeSelectionModel = Context.lookup(TimeRangeSelectionModel.SelectedTimeRangeModel.class);
        this.timeRangeSelectionListener = new TimeRangeSelectionListener();
        this.add(this.chartPanel);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.timeRangeSelectionModel.addChangeListener(this.timeRangeSelectionListener);
        UIElementSelectionModel.getInstance().addChangeListener(this.timeRangeSelectionListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.timeRangeSelectionModel.removeChangeListener(this.timeRangeSelectionListener);
        UIElementSelectionModel.getInstance().removeChangeListener(this.timeRangeSelectionListener);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        TimeRange selectedTimeRange = this.timeRangeSelectionModel.getSelection();
        if (selectedTimeRange == null) {
            return;
        }
        if (this.chartPanel == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle2D screenDataArea = this.chartPanel.getScreenDataArea();
        AffineTransform translate = AffineTransform.getTranslateInstance(this.chartPanel.getX(), this.chartPanel.getY());
        g2.transform(translate);
        g2.setClip(screenDataArea);
        JFreeChart chart = this.chartPanel.getChart();
        if (chart != null) {
            ValueAxis axis = chart.getXYPlot().getDomainAxis();
            double s = axis.getLowerBound();
            double e = axis.getUpperBound();
            double gx = screenDataArea.getX();
            double gw = screenDataArea.getWidth();
            RelativeTimestamp start = selectedTimeRange.getStart();
            RelativeTimestamp end = selectedTimeRange.getEnd();
            double x1 = start == null ? 0.0 : gw * ((double)start.getInUnits(TimeUnit.NANOSECONDS) - s) / (e - s) + gx;
            double x2 = end == null ? 0.0 : gw * ((double)end.getInUnits(TimeUnit.NANOSECONDS) - s) / (e - s) + gx;
            g2.setColor(Color.red);
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2.draw(new Line2D.Double(x1, screenDataArea.getY(), x1, screenDataArea.getY() + screenDataArea.getHeight()));
            g2.draw(new Line2D.Double(x2, screenDataArea.getY(), x2, screenDataArea.getY() + screenDataArea.getHeight()));
            g2.setComposite(AlphaComposite.getInstance(3, 0.05f));
            g2.fill(new Rectangle2D.Double(x1, screenDataArea.getY(), x2 - x1, screenDataArea.getHeight()));
        }
        g2.dispose();
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    private final class TimeRangeSelectionListener
    implements ChangeListener {
        private TimeRangeSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            GraphPreviewPanel.this.chartPanel.getChart().fireChartChanged();
            GraphPreviewPanel.this.repaint();
        }
    }
}

