/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.marks.Mark;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.ui.ColorPalette;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jfree.chart.entity.ChartEntity;

public final class Markline
extends ChartEntity {
    private static final WeakHashMap<Mark, Boolean> labelsVisibilityMap = new WeakHashMap();
    private final Mark mark;

    public Markline(Shape area, Mark mark) {
        super(area);
        this.mark = mark;
    }

    public static boolean isLabelVisible(Mark mark) {
        Boolean r = labelsVisibilityMap.get(mark);
        return r == null ? mark.isUserMark() : r.booleanValue();
    }

    @Override
    public String getToolTipText() {
        DisplayTimeModel dtm = Context.lookup(DisplayTimeModel.class);
        return "<html>Category: " + this.mark.getCategory() + "<br>Label: " + this.mark.getLabel() + "<br>Time: " + dtm.toString(this.mark.getTimestamp()) + "<br><br><font color='gray'><i>" + KeyEvent.getModifiersExText(64) + "-Click to show/hide markline label</i><br><i>" + KeyEvent.getModifiersExText(576) + "-Click to show/hide labels of selected markline category</i></font>";
    }

    public Mark getMark() {
        return this.mark;
    }

    public boolean isSelected() {
        return this.mark.isSelected();
    }

    public boolean isLabelVisible() {
        return Markline.isLabelVisible(this.mark);
    }

    public void setLabelVisible(boolean visible) {
        labelsVisibilityMap.put(this.mark, visible);
    }

    public void changeLabelVisibility() {
        boolean r = this.isLabelVisible();
        labelsVisibilityMap.put(this.mark, !r);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Markline)) {
            return false;
        }
        return this.mark.equals(((Markline)obj).mark) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.mark);
        return hash;
    }

    public static final class AttributesProvider {
        private static final Color userCategoryColor = Color.decode("#f81b1b");
        private static final Font font = new Font("SansSerif", 0, 12);
        private static final Map<String, Color> preferredColors = new HashMap<String, Color>();
        private static Iterator<Color> colors = null;

        private AttributesProvider() {
        }

        public static Color getLineColor(String category) {
            Color color = preferredColors.get(category);
            if (color == null) {
                color = "user".equals(category) ? userCategoryColor : colors.next();
                preferredColors.put(category, color);
            }
            return color;
        }

        public static void reset() {
            colors = ColorPalette.iterator();
        }

        public static void setPreferredCategoryColor(String category, Color color) {
            preferredColors.put(category, color);
        }

        public static void updatePreferredColors(ConcurrentHashMap<String, Color> newColors) {
            AtomicBoolean modified = new AtomicBoolean();
            newColors.forEach((key, new_color) -> preferredColors.computeIfPresent((String)key, (k, old_color) -> {
                modified.compareAndSet(false, !old_color.equals(new_color));
                return new_color;
            }));
            if (modified.get()) {
                MarksModel.fireModelChange();
            }
        }

        public static Color getLineColor(Mark mark) {
            return AttributesProvider.getLineColor(mark.getCategory());
        }

        public static Color getLabelColor(String category) {
            Color color = AttributesProvider.getLineColor(category);
            int y = (299 * color.getRed() + 587 * color.getGreen() + 114 * color.getBlue()) / 1000;
            return y >= 128 ? Color.black : Color.white;
        }

        public static Color getLabelColor(Mark mark) {
            return AttributesProvider.getLabelColor(mark.getCategory());
        }

        public static Font getLabelFont(Mark mark) {
            return font;
        }
    }
}

