/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.ui.NMT_SearchPanel;
import com.azul.log.gui.utils.UIUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class NMT_SearchBar
extends JPanel {
    private static final int MIN_SEARCHBAR_PANELS = 1;
    private static final int MAX_SEARCHBAR_PANELS = 15;
    private static final Map<String, Function<String, Function<String, Boolean>>> searchFunctionMap = new HashMap<String, Function<String, Function<String, Boolean>>>(){
        {
            this.put("JVM Component", searchString -> inputText -> inputText.contains((CharSequence)searchString));
            this.put("Size", searchString -> inputText -> {
                String sizeString = inputText.substring(0, inputText.length() - 2);
                if (!searchString.contains("-")) {
                    int lowerBound = Integer.parseInt(searchString.trim());
                    int size = Integer.parseInt(sizeString);
                    return size >= lowerBound;
                }
                int separator = searchString.indexOf(45);
                int lowerBound = Integer.parseInt(searchString.substring(0, separator).trim());
                int upperBound = Integer.parseInt(searchString.substring(separator + 1).trim());
                int size = Integer.parseInt(sizeString);
                return size >= lowerBound && size <= upperBound;
            });
            this.put("Method Name", searchString -> inputText -> inputText.contains((CharSequence)searchString));
        }
    };
    private final List<SearchRow> searchRows;
    private final JPanel enclosingPanel;
    private final ActionListener searchKeyboardActionListener;
    private final NMT_SearchPanel searchPanel;
    private final Runnable refreshSearch;

    public NMT_SearchBar(NMT_SearchPanel searchPanel, ActionListener searchKeyboardActionListener, Runnable refreshSearch) {
        this.searchPanel = searchPanel;
        this.searchKeyboardActionListener = searchKeyboardActionListener;
        this.refreshSearch = refreshSearch;
        this.searchRows = new ArrayList<SearchRow>();
        this.enclosingPanel = this;
        this.setLayout(new BoxLayout(this, 1));
        this.addNewSearchRow();
    }

    private void addNewSearchRow() {
        SearchRow searchRow = new SearchRow();
        this.enclosingPanel.add(searchRow);
        this.searchRows.add(searchRow);
        this.checkAddRemoveButtonStatus();
        this.enclosingPanel.revalidate();
        this.enclosingPanel.repaint();
        searchRow.getSearchField().requestFocusInWindow();
    }

    private void checkAddRemoveButtonStatus() {
        if (this.searchRows.size() == 1) {
            this.searchRows.get(0).getRemoveButton().setEnabled(false);
            this.searchRows.get(0).getAddButton().setEnabled(true);
            this.searchRows.get(0).getSearchField().requestFocusInWindow();
        } else if (this.searchRows.size() == 15) {
            for (SearchRow panel : this.searchRows) {
                panel.getAddButton().setEnabled(false);
            }
        } else {
            for (int i = 0; i < this.searchRows.size(); ++i) {
                SearchRow panel = this.searchRows.get(i);
                panel.getRemoveButton().setEnabled(true);
                panel.getAddButton().setEnabled(false);
            }
            int lastRowIndex = this.searchRows.size() - 1;
            this.searchRows.get(lastRowIndex).getAddButton().setEnabled(true);
            this.searchRows.get(lastRowIndex).getSearchField().requestFocusInWindow();
        }
    }

    public Map<String, Function<String, Boolean>> getRowFilters() {
        int searchRowCount = 0;
        HashMap<String, Function<String, Boolean>> filters = new HashMap<String, Function<String, Boolean>>();
        for (SearchRow panel : this.searchRows) {
            String searchText;
            String string = searchText = this.searchPanel.isCaseSensitive() ? panel.getSearchField().getText() : panel.getSearchField().getText().toUpperCase();
            if (searchText.isEmpty()) continue;
            String selectedOperation = panel.getSearchComboBox().getSelectedItem().toString();
            filters.put(selectedOperation + searchRowCount++, searchFunctionMap.get(selectedOperation).apply(searchText));
        }
        return filters;
    }

    /*
     * Exception decompiling
     */
    public List<String[]> getSearchOpList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JTextField getLastTextField() {
        return this.searchRows.get(this.searchRows.size() - 1).getSearchField();
    }

    public Optional<String> getLastNonEmptyText() {
        return this.searchRows.stream().map(panel -> panel.getSearchField().getText()).filter(searchText -> !searchText.isEmpty()).reduce((first, second) -> second);
    }

    public boolean isSearchTextAvailable() {
        return this.getLastNonEmptyText().isPresent();
    }

    private final class SearchRow
    extends JPanel {
        final JTextField searchField;
        final SearchComboBox searchComboBox;
        final JButton addButton;
        final JButton removeButton;

        public SearchRow() {
            this.setLayout(new BoxLayout(this, 0));
            this.searchField = new JTextField(20);
            this.searchComboBox = new SearchComboBox(this.searchField);
            this.addButton = new JButton("+");
            this.removeButton = new JButton("-");
            this.addButton.addActionListener(e -> NMT_SearchBar.this.addNewSearchRow());
            this.removeButton.addActionListener(e -> {
                if (NMT_SearchBar.this.searchRows.size() > 1) {
                    NMT_SearchBar.this.searchRows.remove(this);
                    NMT_SearchBar.this.enclosingPanel.remove(this);
                    NMT_SearchBar.this.enclosingPanel.revalidate();
                    NMT_SearchBar.this.enclosingPanel.repaint();
                    if (!this.searchField.getText().isEmpty()) {
                        NMT_SearchBar.this.refreshSearch.run();
                    }
                    NMT_SearchBar.this.checkAddRemoveButtonStatus();
                }
            });
            this.add(this.searchComboBox);
            this.add(this.searchField);
            this.add(this.addButton);
            this.add(this.removeButton);
            InputMap im = this.searchField.getInputMap(0);
            im.put(KeyStroke.getKeyStroke(61, UIUtils.MENU_SHORTCUT_KEY_MASK, false), "addRow");
            im.put(KeyStroke.getKeyStroke(45, UIUtils.MENU_SHORTCUT_KEY_MASK, false), "delRow");
            this.searchField.getActionMap().put("addRow", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SearchRow.this.addButton.isEnabled()) {
                        SearchRow.this.addButton.doClick();
                    }
                }
            });
            this.searchField.getActionMap().put("delRow", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SearchRow.this.removeButton.isEnabled()) {
                        SearchRow.this.removeButton.doClick();
                    }
                }
            });
        }

        public JTextField getSearchField() {
            return this.searchField;
        }

        public SearchComboBox getSearchComboBox() {
            return this.searchComboBox;
        }

        public JButton getAddButton() {
            return this.addButton;
        }

        public JButton getRemoveButton() {
            return this.removeButton;
        }
    }

    private final class SearchComboBox
    extends JComboBox<String> {
        public final JTextField companionSearchField;

        public SearchComboBox(final JTextField companionSearchField) {
            super(new String[]{"JVM Component", "Size"});
            this.companionSearchField = companionSearchField;
            KeyStroke copy = KeyStroke.getKeyStroke(67, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
            KeyStroke paste = KeyStroke.getKeyStroke(86, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
            KeyStroke cut = KeyStroke.getKeyStroke(88, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
            KeyStroke selectAll = KeyStroke.getKeyStroke(65, UIUtils.MENU_SHORTCUT_KEY_MASK, false);
            InputMap im = companionSearchField.getInputMap(0);
            im.put(copy, "copy-to-clipboard");
            im.put(paste, "paste-from-clipboard");
            im.put(cut, "cut-to-clipboard");
            im.put(selectAll, "select-all");
            im.put(KeyStroke.getKeyStroke(77, 64, false), "ignore");
            companionSearchField.getActionMap().put("ignore", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            companionSearchField.addKeyListener(new KeyAdapter(){
                String previousValue = "";

                @Override
                public void keyPressed(KeyEvent e) {
                    this.previousValue = companionSearchField.getText();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (!this.previousValue.equals(companionSearchField.getText())) {
                        NMT_SearchBar.this.refreshSearch.run();
                    }
                }
            });
            this.addItemListener(e -> {
                if (!companionSearchField.getText().isEmpty()) {
                    NMT_SearchBar.this.refreshSearch.run();
                    companionSearchField.requestFocusInWindow();
                }
            });
        }

        @Override
        public void addActionListener(ActionListener l) {
            if (!this.companionSearchField.getText().isEmpty()) {
                NMT_SearchBar.this.refreshSearch.run();
            }
        }
    }
}

