/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.OpenFileAction;
import com.azul.log.gui.support.OpenFileSupport;
import com.azul.log.gui.utils.UIUtils;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public final class OpenFileButtonPanel
extends JPanel {
    OpenFileButtonPanel(OpenFileSupport.LogFilesOpenHandler openLogsHandler) {
        super(new GridBagLayout());
        this.add((Component)new OpenFileButton(openLogsHandler), new GridBagConstraints());
    }

    private static final class OpenFileButton
    extends JButton {
        private WeakReference<ImageIcon> scaledOpenButtonIcon = new WeakReference<Object>(null);

        private OpenFileButton(OpenFileSupport.LogFilesOpenHandler openLogHandler) {
            this.setIcon(UIUtils.loadIcon("/dnd.png"));
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    this.setIcon(UIUtils.loadIcon("/dnd.png"));
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    ImageIcon scaled = (ImageIcon)scaledOpenButtonIcon.get();
                    if (scaled == null) {
                        ImageIcon icon = (ImageIcon)this.getIcon();
                        BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                        Graphics2D g2 = img.createGraphics();
                        icon.paintIcon(null, g2, 0, 0);
                        AffineTransformOp scaleOp = new AffineTransformOp(AffineTransform.getScaleInstance(1.05, 1.05), 2);
                        scaled = new ImageIcon(scaleOp.filter(img, null));
                        scaledOpenButtonIcon = new WeakReference<ImageIcon>(scaled);
                    }
                    this.setIcon(scaled);
                }
            });
            this.addActionListener(new OpenFileAction(null, openLogHandler));
            UIUtils.autoScale(this);
        }
    }
}

