/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.ViewLogAction;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.ParserExceptionsModel;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.ParserException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public final class ParserExceptionsPanel
extends JPanel {
    private final ParserExceptionsModel exceptions = ParserExceptionsModel.getModel();
    private final ChangeListener listener;
    private final JTable table;

    public ParserExceptionsPanel() {
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.table = new JTable();
        scrollPane.setViewportView(this.table);
        scrollPane.getViewport().setBackground(Color.white);
        DefaultTableModel tableModel = new DefaultTableModel();
        tableModel.addColumn("Line #");
        tableModel.addColumn("Parsing Error");
        this.table.setModel(tableModel);
        this.table.setDefaultEditor(Object.class, null);
        this.table.setAutoResizeMode(3);
        this.table.setFont(new Font("Courier New", 0, 13));
        DefaultTableCellRenderer lineNumberRenderer = new DefaultTableCellRenderer();
        lineNumberRenderer.setBackground(Color.decode("#fffff7"));
        lineNumberRenderer.setHorizontalAlignment(4);
        this.table.getColumnModel().getColumn(0).setCellRenderer(lineNumberRenderer);
        Dimension size = MainFrame.get().getSize();
        size = new Dimension((int)((double)size.width * 0.5), (int)((double)size.height * 0.5));
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.listener = e -> {
            List<ParserException> list = this.exceptions.getExceptions();
            if (list.isEmpty()) {
                tableModel.setRowCount(0);
                tableModel.fireTableDataChanged();
            } else {
                int oldCount = tableModel.getRowCount();
                int newCount = list.size() - 1;
                for (int i = oldCount; i <= newCount; ++i) {
                    ParserException ex = list.get(i);
                    tableModel.addRow(new Object[]{ex.getLineNumber(), " " + ex.getMessage()});
                }
                tableModel.newRowsAdded(new TableModelEvent(tableModel, oldCount, newCount));
                Component comp = this.table.prepareRenderer(this.table.getCellRenderer(newCount, 0), newCount, 0);
                TableColumn col0 = this.table.getColumnModel().getColumn(0);
                col0.setMaxWidth(comp.getPreferredSize().width);
                col0.setMinWidth(comp.getPreferredSize().width);
            }
        };
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = ParserExceptionsPanel.this.table.rowAtPoint(e.getPoint());
                    UIElementSelectionModel.getInstance().setSelectedElement(new UIElement(RelativeTimestamp.of(0.0, TimeUnit.SECONDS), (Integer)ParserExceptionsPanel.this.table.getValueAt(row, 0), Context.lookup(LogModel.class)));
                    new ViewLogAction().actionPerformed((ActionEvent)null);
                }
            }
        });
        UIUtils.fixCopyPasteActionHotKeys(this.table);
        this.add((Component)scrollPane, "Center");
        JLabel hint = new JLabel("Hint: Double-click a row to see the whole line in the LogView...");
        hint.setEnabled(false);
        this.add((Component)hint, "South");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.exceptions.addChangeListener(this.listener);
        this.listener.stateChanged(null);
    }

    @Override
    public void removeNotify() {
        this.exceptions.removeChangeListener(this.listener);
        super.removeNotify();
    }
}

