/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.model.PersistentModel;
import javax.swing.JSplitPane;

public final class PersistentJSplitPane
extends JSplitPane {
    private final PersistentModel model;

    public PersistentJSplitPane(String id) {
        this.model = new PersistentModelImpl(id + ".sliderPosition");
    }

    public PersistentJSplitPane(String id, int defaultPosition) {
        this.model = new PersistentModelImpl(id + ".sliderPosition", defaultPosition);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Config.bind(this, "dividerLocation", this.model);
    }

    private class PersistentModelImpl
    implements PersistentModel {
        private final String id;

        private PersistentModelImpl(String id) {
            this.id = id;
        }

        private PersistentModelImpl(String id, int defaultPosition) {
            this.id = id;
            PersistentJSplitPane.this.setDividerLocation(defaultPosition);
        }

        @Override
        public String getPersistentID() {
            return this.id;
        }

        @Override
        public void initFromExternalString(String data) {
            PersistentJSplitPane.this.setDividerLocation(Integer.parseInt(data));
        }

        @Override
        public String toExternalString() {
            return "" + PersistentJSplitPane.this.getDividerLocation();
        }
    }
}

