/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.ui.nodes.Node;
import com.azul.log.gui.utils.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class QuickSearchPanel
extends JPanel {
    private final JTextField textField = UIUtils.fixCopyPasteActionHotKeys(new JTextField());
    private final QuickSearchListener scl = new QuickSearchListener();
    private final TreeKeyAdapter treeKeyListener = new TreeKeyAdapter();
    private final JTree tree;
    private final List<TreePath> paths = new ArrayList<TreePath>();
    private int selection;

    public QuickSearchPanel(JTree tree) {
        super(new BorderLayout());
        this.tree = tree;
        this.add((Component)this.textField, "Center");
        this.setVisible(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                QuickSearchPanel.this.textField.addFocusListener(QuickSearchPanel.this.scl);
                QuickSearchPanel.this.textField.addKeyListener(QuickSearchPanel.this.scl);
                QuickSearchPanel.this.textField.getDocument().addDocumentListener(QuickSearchPanel.this.scl);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                QuickSearchPanel.this.textField.removeFocusListener(QuickSearchPanel.this.scl);
                QuickSearchPanel.this.textField.removeKeyListener(QuickSearchPanel.this.scl);
                QuickSearchPanel.this.textField.getDocument().removeDocumentListener(QuickSearchPanel.this.scl);
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tree.addKeyListener(this.treeKeyListener);
    }

    @Override
    public void removeNotify() {
        this.tree.removeKeyListener(this.treeKeyListener);
        super.removeNotify();
    }

    private void hidePanel() {
        if (!this.isVisible()) {
            return;
        }
        this.setVisible(false);
        if (this.tree.getModel().getRoot() == null) {
            return;
        }
        Rectangle pathBounds = this.tree.getPathBounds(this.paths.get(this.selection));
        if (pathBounds != null) {
            this.tree.scrollRectToVisible(new Rectangle(0, pathBounds.y, 10, pathBounds.height));
            this.paths.clear();
            this.tree.requestFocus();
        }
    }

    private void showPanel() {
        if (this.isVisible()) {
            return;
        }
        this.setVisible(true);
        this.textField.requestFocus();
        if (this.tree.getModel().getRoot() == null) {
            return;
        }
        this.selection = 0;
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)e.nextElement();
            if (!treeNode.isLeaf() || !(treeNode.getUserObject() instanceof Node)) continue;
            TreePath treePath = new TreePath(treeNode.getPath());
            if (treePath.equals(this.tree.getSelectionPath())) {
                this.selection = this.paths.size();
            }
            this.paths.add(treePath);
        }
    }

    private void selectNode(String text) {
        int i;
        text = text.toLowerCase();
        for (i = this.selection; i < this.paths.size(); ++i) {
            if (!this.selectIfMatches(i, text)) continue;
            return;
        }
        for (i = 0; i < this.selection; ++i) {
            if (!this.selectIfMatches(i, text)) continue;
            return;
        }
    }

    private void selectNext(String text) {
        int i;
        text = text.toLowerCase();
        for (i = this.selection + 1; i < this.paths.size(); ++i) {
            if (!this.selectIfMatches(i, text)) continue;
            return;
        }
        for (i = 0; i < this.selection; ++i) {
            if (!this.selectIfMatches(i, text)) continue;
            return;
        }
    }

    private void selectPrev(String text) {
        int i;
        text = text.toLowerCase();
        for (i = this.selection - 1; i >= 0; --i) {
            if (!this.selectIfMatches(i, text)) continue;
            return;
        }
        for (i = this.paths.size() - 1; i > this.selection; --i) {
            if (!this.selectIfMatches(i, text)) continue;
            return;
        }
    }

    private boolean selectIfMatches(int idx, String text) {
        TreePath path = this.paths.get(idx);
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)path.getLastPathComponent();
        Node userObject = (Node)tn.getUserObject();
        if (userObject.getDisplayName().toLowerCase().contains(text)) {
            TreePath prev = this.tree.getSelectionPath();
            this.tree.setSelectionPath(path);
            TreePath cur = this.tree.getSelectionPath();
            if (this.selection == idx || !Objects.equals(cur, prev)) {
                this.selection = idx;
                this.tree.scrollPathToVisible(path);
                return true;
            }
        }
        return false;
    }

    private class TreeKeyAdapter
    extends KeyAdapter {
        private boolean armed = false;

        private TreeKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int modifiers = e.getModifiersEx();
            int keyCode = e.getKeyCode();
            if (modifiers > 0 && modifiers != 64 || e.isActionKey()) {
                return;
            }
            char c = e.getKeyChar();
            if (!Character.isISOControl(c) && keyCode != 16 && keyCode != 27) {
                this.armed = true;
                e.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.armed) {
                QuickSearchPanel.this.showPanel();
                KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                QuickSearchPanel.this.textField.setText(String.valueOf(stroke.getKeyChar()));
                e.consume();
                this.armed = false;
            }
        }
    }

    private class QuickSearchListener
    extends KeyAdapter
    implements FocusListener,
    DocumentListener {
        private QuickSearchListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 27: {
                    QuickSearchPanel.this.hidePanel();
                    e.consume();
                    break;
                }
                case 38: {
                    QuickSearchPanel.this.selectPrev(QuickSearchPanel.this.textField.getText());
                    e.consume();
                    break;
                }
                case 40: {
                    QuickSearchPanel.this.selectNext(QuickSearchPanel.this.textField.getText());
                    e.consume();
                    break;
                }
                default: {
                    super.keyPressed(e);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            QuickSearchPanel.this.hidePanel();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            QuickSearchPanel.this.selectNode(QuickSearchPanel.this.textField.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            QuickSearchPanel.this.selectNode(QuickSearchPanel.this.textField.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            QuickSearchPanel.this.selectNode(QuickSearchPanel.this.textField.getText());
        }
    }
}

