/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.LogRecordElement;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.tables.api.TableDefinition;
import com.azul.log.gui.ui.TableViewBase;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.RelativeTimestamp;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public final class TableView
extends TableViewBase {
    private final DisplayTimeModel displayTimeModel = Context.lookup(DisplayTimeModel.class);
    private final TimeUnitsListener timeUnitsListener;
    private final TableDefinition td;

    public TableView(TableDefinition td) {
        super(td, new ConverterImpl(td), td.getLogModel());
        this.td = td;
        this.timeUnitsListener = new TimeUnitsListener();
        this.table.setRowSorter(null);
        this.table.getTableHeader().setDefaultRenderer(new HeaderRendererImpl(this.table.getTableHeader().getDefaultRenderer()));
        this.table.setDefaultRenderer(Object.class, new CellRendererImpl());
    }

    @Override
    protected int getRowFor(UIElement selection) {
        if (selection instanceof LogRecordElement) {
            RelativeTimestamp timestamp = ((LogRecordElement)selection).getLogRecord().getEventRelativeTimestamp();
            return this.td.getClosestRow(timestamp);
        }
        return -1;
    }

    @Override
    public LogRecord getRecordAtRow(int row) {
        return this.td.getRecord(row);
    }

    @Override
    protected RelativeTimestamp getRelativeTimestampForRow(int row) {
        return (RelativeTimestamp)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(row), 0);
    }

    @Override
    protected void installListeners() {
        this.displayTimeModel.addChangeListener(this.timeUnitsListener);
    }

    @Override
    protected void uninstallListeners() {
        this.displayTimeModel.removeChangeListener(this.timeUnitsListener);
    }

    private class TimeUnitsListener
    implements ChangeListener {
        private TimeUnitsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ((AbstractTableModel)TableView.this.table.getModel()).fireTableDataChanged();
        }
    }

    private static class ConverterImpl
    implements TableViewBase.TableRowToInfoConvertor {
        private final TableDefinition td;

        public ConverterImpl(TableDefinition td) {
            this.td = td;
        }

        @Override
        public UIElement getElementAtRow(TableViewBase view, int row) {
            return new LogRecordElement(this.td.getRecord(row), this.td.getLogModel());
        }
    }

    private class CellRendererImpl
    extends DefaultTableCellRenderer {
        private CellRendererImpl() {
        }

        @Override
        public int getHorizontalAlignment() {
            return 4;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String str;
            if (value != null) {
                Class<Comparable<RelativeTimestamp>> type = value.getClass();
                if (type.isAssignableFrom(RelativeTimestamp.class)) {
                    RelativeTimestamp ts = (RelativeTimestamp)value;
                    str = TableView.this.displayTimeModel.toString(ts);
                } else {
                    str = type.isAssignableFrom(Double.class) ? String.format("%3.3f", (Double)value) : value.toString();
                }
            } else {
                str = "";
            }
            return super.getTableCellRendererComponent(table, str, isSelected, hasFocus, row, column);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Point sp = event.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(sp, TableView.this.table);
            int rowIndex = TableView.this.table.convertRowIndexToModel(TableView.this.table.rowAtPoint(sp));
            int colIndex = TableView.this.table.convertColumnIndexToModel(TableView.this.table.columnAtPoint(sp));
            return TableView.this.td.getValueTooltipAt(rowIndex, colIndex);
        }
    }

    private class HeaderRendererImpl
    extends DefaultTableCellRenderer {
        private final TableCellRenderer rend;

        public HeaderRendererImpl(TableCellRenderer rend) {
            this.rend = rend;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent comp = (JComponent)this.rend.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setToolTipText(TableView.this.td.getColumnTooltip(table.convertColumnIndexToModel(column)));
            return comp;
        }
    }
}

