/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.MarksActions;
import com.azul.log.gui.marks.Mark;
import com.azul.log.gui.marks.MarksModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.TimeRange;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.UIElementSelectionModel;
import com.azul.log.gui.ui.Markline;
import com.azul.log.gui.ui.ScrollBarUIEx;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.RelativeTimestamp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.openide.util.Lookup;

abstract class TableViewBase
extends JPanel
implements Lookup.Provider {
    protected final JTable table;
    private final UIElementSelectionModel infoSelection = UIElementSelectionModel.getInstance();
    private final SelectionListener tableListener = new SelectionListener();
    private final InfoSelectionListener infoSelectionListener = new InfoSelectionListener();
    private final TableRowToInfoConvertor converter;
    private final LogModel logModel;
    private final Runnable refreshRowHeaderView;

    public TableViewBase(TableModel model, TableRowToInfoConvertor converter, LogModel logModel) {
        super(new BorderLayout());
        this.converter = converter;
        this.logModel = logModel;
        this.table = new JTable(model);
        this.table.setAutoResizeMode(0);
        UIUtils.fixCopyPasteActionHotKeys(this.table);
        JScrollPane scrollPane = new JScrollPane(this.table);
        ScrollBarUIEx.setup(scrollPane, false);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
        scrollPane.getViewport().setBackground(Color.white);
        RowHeaderView rowHeaderView = new RowHeaderView();
        scrollPane.setRowHeaderView(rowHeaderView);
        super.add((Component)scrollPane, "Center");
        this.refreshRowHeaderView = () -> rowHeaderView.stateChanged(null);
    }

    public abstract LogRecord getRecordAtRow(int var1);

    public UIElementSelectionModel getSelectionModel() {
        return this.infoSelection;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        FontMetrics metrics = this.table.getFontMetrics(this.getFont());
        this.table.setRowHeight(metrics.getHeight());
        this.table.getSelectionModel().addListSelectionListener(this.tableListener);
        this.infoSelection.addChangeListener(this.infoSelectionListener);
        SwingUtilities.invokeLater(() -> this.infoSelectionListener.stateChanged(null));
        this.installListeners();
    }

    @Override
    public void removeNotify() {
        this.uninstallListeners();
        this.table.getSelectionModel().removeListSelectionListener(this.tableListener);
        this.infoSelection.removeChangeListener(this.infoSelectionListener);
        super.removeNotify();
    }

    @Override
    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    protected void updateRowHeader() {
        this.refreshRowHeaderView.run();
    }

    protected boolean isLogViewFiltered() {
        return this.table.getRowCount() < this.table.getModel().getRowCount();
    }

    protected void ensureRowIsVisible(int row) {
        Rectangle line_rect = new Rectangle(this.table.getCellRect(row, 0, true));
        Rectangle visibleRect = this.table.getVisibleRect();
        line_rect.width = 99;
        visibleRect.width = 100;
        if (!visibleRect.contains(line_rect)) {
            line_rect.y -= (visibleRect.height - line_rect.height) / 2;
            line_rect.height = visibleRect.height;
            this.table.scrollRectToVisible(line_rect);
        }
    }

    protected abstract void installListeners();

    protected abstract void uninstallListeners();

    protected abstract int getRowFor(UIElement var1);

    protected abstract RelativeTimestamp getRelativeTimestampForRow(int var1);

    private class RowHeaderView
    extends JComponent
    implements MouseListener,
    MouseMotionListener,
    ChangeListener {
        private final MarksModel marks = Context.lookup(MarksModel.class);
        private int lastRow = -1;

        private RowHeaderView() {
        }

        @Override
        public void addNotify() {
            Font font = TableViewBase.this.table.getFont();
            FontMetrics fontMetrics = TableViewBase.this.table.getFontMetrics(font);
            Rectangle2D stringBounds = fontMetrics.getStringBounds("" + TableViewBase.this.table.getRowCount(), null);
            Dimension preferredSize = new Dimension((int)stringBounds.getWidth() + 11, TableViewBase.this.table.getPreferredSize().height);
            this.setPreferredSize(preferredSize);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            if (this.marks != null) {
                this.marks.addChangeListener(this);
            }
            TableViewBase.this.infoSelection.addChangeListener(this);
            super.addNotify();
        }

        @Override
        public void removeNotify() {
            if (this.marks != null) {
                this.marks.removeChangeListener(this);
            }
            TableViewBase.this.infoSelection.removeChangeListener(this);
            super.removeNotify();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            Font font = TableViewBase.this.table.getFont();
            FontMetrics fontMetrics = TableViewBase.this.table.getFontMetrics(font);
            g2d.setFont(font);
            Rectangle b = g2d.getClipBounds();
            g2d.setColor(Color.decode("#fffff7"));
            g2d.fillRect(b.x, b.y, b.width, b.height);
            int bottom = b.y + b.height;
            int rowCount = TableViewBase.this.table.getRowCount();
            int row = TableViewBase.this.table.rowAtPoint(b.getLocation());
            g2d.setColor(Color.gray);
            g2d.drawLine(b.width, b.y, b.width, bottom);
            int w = b.width - 5;
            g2d.translate(b.x + 3, 0);
            while (true) {
                Mark mark;
                g2d.setColor(Color.gray);
                Rectangle rect = TableViewBase.this.table.getCellRect(row, 0, false);
                if (rect.y > bottom || row < 0 || row >= rowCount) break;
                g2d.translate(0, rect.y);
                if (this.marks != null && (mark = this.marks.getMarkAtLogLine(1 + TableViewBase.this.table.convertRowIndexToModel(++row - 1))) != null && mark.belongsTo(TableViewBase.this.logModel)) {
                    Polygon s = new Polygon(new int[]{0, w, w, 0, 4, 0}, new int[]{0, 0, rect.height, rect.height, rect.height / 2, 0}, 6);
                    g2d.setColor(Markline.AttributesProvider.getLineColor(mark));
                    g2d.fillPolygon(s);
                    g2d.setColor(Markline.AttributesProvider.getLabelColor(mark));
                }
                String line = "" + (1 + TableViewBase.this.table.convertRowIndexToModel(row - 1));
                Rectangle stringBounds = fontMetrics.getStringBounds(line, g).getBounds();
                g2d.drawString(line, w - stringBounds.width, rect.height - 3);
                g2d.translate(0, -rect.y);
            }
            g2d.dispose();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.marks == null || e.getButton() != 1) {
                return;
            }
            int clickCount = e.getClickCount();
            int row = TableViewBase.this.table.rowAtPoint(e.getPoint());
            if (row < 0) {
                return;
            }
            Mark mark = this.marks.getMarkAtLogLine(TableViewBase.this.table.convertRowIndexToModel(row) + 1);
            if (mark != null && !mark.belongsTo(TableViewBase.this.logModel)) {
                return;
            }
            if (clickCount == 1) {
                if (mark != null || TableViewBase.this.table.getSelectedRow() != row || TableViewBase.this.table.getSelectedRowCount() != 1) {
                    TableViewBase.this.infoSelection.setSelectedElement(mark);
                    TableViewBase.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
            } else if (mark == null && clickCount == 2) {
                MarksActions.createMarkFromSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.invalidate();
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = TableViewBase.this.table.rowAtPoint(e.getPoint());
            if (row < 0) {
                return;
            }
            if ((row = TableViewBase.this.table.convertRowIndexToModel(row)) != this.lastRow) {
                Mark mark;
                this.lastRow = row;
                if (this.marks != null && (mark = this.marks.getMarkAtLogLine(row + 1)) != null && mark.belongsTo(TableViewBase.this.logModel)) {
                    DisplayTimeModel displayTimeModel = Context.lookup(DisplayTimeModel.class);
                    String tooltip = "<html>Category: " + mark.getCategory() + "<br>Label: " + mark.getLabel() + "<br>Time: " + displayTimeModel.toString(mark.getTimestamp());
                    this.setToolTipText(tooltip);
                } else {
                    this.setToolTipText(null);
                }
                this.invalidate();
                this.repaint();
            }
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                this.setSelectedTimeRange(null);
                TableViewBase.this.infoSelection.setSelectedElement(null);
                return;
            }
            int firstIndex = TableViewBase.this.table.convertRowIndexToModel(lsm.getMinSelectionIndex());
            int lastIndex = TableViewBase.this.table.convertRowIndexToModel(lsm.getMaxSelectionIndex());
            RelativeTimestamp startTS = TableViewBase.this.getRelativeTimestampForRow(firstIndex);
            if (firstIndex == lastIndex) {
                UIElement element;
                this.setSelectedTimeRange(startTS == null ? null : new TimeRange(startTS, startTS));
                UIElement current = TableViewBase.this.infoSelection.getSelectedElement();
                UIElement uIElement = element = TableViewBase.this.converter == null ? null : TableViewBase.this.converter.getElementAtRow(TableViewBase.this, firstIndex);
                if (current != element) {
                    TableViewBase.this.infoSelection.setSelectedElement(element);
                }
            } else {
                RelativeTimestamp endTS = TableViewBase.this.getRelativeTimestampForRow(lastIndex);
                this.setSelectedTimeRange(startTS == null || endTS == null ? null : new TimeRange(startTS, endTS));
                TableViewBase.this.infoSelection.setSelectedElement(null);
            }
        }

        private void setSelectedTimeRange(TimeRange timeRange) {
            TimeRangeSelectionModel.SelectedTimeRangeModel model = Context.lookup(TimeRangeSelectionModel.SelectedTimeRangeModel.class);
            if (model != null) {
                model.setSelection(timeRange);
            }
        }
    }

    private class InfoSelectionListener
    implements ChangeListener {
        private InfoSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int row;
            UIElement selection = TableViewBase.this.infoSelection.getSelectedElement();
            if (selection != null && TableViewBase.this.logModel.equals(selection.getLogModel()) && 0 <= (row = TableViewBase.this.table.convertRowIndexToView(TableViewBase.this.getRowFor(selection))) && row < TableViewBase.this.table.getRowCount()) {
                TableViewBase.this.table.getSelectionModel().setSelectionInterval(row, row);
                TableViewBase.this.ensureRowIsVisible(row);
            }
        }
    }

    public static interface TableRowToInfoConvertor {
        public UIElement getElementAtRow(TableViewBase var1, int var2);
    }
}

