/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.SearchTextActions;
import com.azul.log.gui.model.Model;
import com.azul.log.gui.search.SearchProgressListener;
import com.azul.log.gui.ui.CompositeSearchBar;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.utils.ChangeSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;

public final class TextSearchPanel
extends JPanel
implements Model,
SearchProgressListener {
    private static final String FIND_NEXT = "searchForward";
    private static final String FIND_PREVIOUS = "searchBackward";
    private static final String CANCEL = "cancel";
    private final ChangeSupport cs = new ChangeSupport(this);
    private final JComponent focusOwner;
    private final JToggleButton btnCase;
    private final JToggleButton btnFilter;
    private final JButton btnNext;
    private final JButton btnPrev = new JButton();
    private final JProgressBar progressBar;
    private final CompositeSearchBar compositeSearchBar;
    private Boolean isCaseSensitive = false;
    private Boolean applyFilter = false;
    private Timer progressBarDisplayTimer;

    public TextSearchPanel(JComponent focusOwner) {
        this.btnNext = new JButton();
        this.btnCase = new JToggleButton();
        this.btnFilter = new JToggleButton();
        this.progressBar = new JProgressBar();
        this.focusOwner = focusOwner;
        AtomicBoolean searchCancelled = new AtomicBoolean(false);
        ActionListener listener = e -> {
            String command = e.getActionCommand();
            if (CANCEL.equals(command)) {
                SearchTextActions.CANCEL.actionPerformed(e);
                if (searchCancelled.get()) {
                    this.btnCancelActionPerformed(e);
                } else {
                    searchCancelled.set(true);
                }
                return;
            }
            searchCancelled.set(false);
            switch (command) {
                case "searchForward": {
                    this.btnNext.getAction().actionPerformed(e);
                    break;
                }
                case "searchBackward": {
                    this.btnPrev.getAction().actionPerformed(e);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        };
        Runnable refreshSearch = this.cs::fireChange;
        this.compositeSearchBar = new CompositeSearchBar(this, listener, refreshSearch);
        this.initComponents();
        this.setCaseSensitive(this.isCaseSensitive);
        this.setFilterStatus(this.applyFilter);
        this.registerKeyboardAction(listener, CANCEL, KeyStroke.getKeyStroke(27, 0), 1);
        this.progressBar.setVisible(false);
    }

    @Override
    public void startProgress(int max) {
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(max);
        this.progressBarDisplayTimer = new Timer(500, e -> this.progressBar.setVisible(true));
        this.progressBarDisplayTimer.start();
    }

    @Override
    public void setProgress(int value) {
        SwingUtilities.invokeLater(() -> this.progressBar.setValue(value));
    }

    @Override
    public void stopProgress() {
        this.progressBarDisplayTimer.stop();
        this.progressBar.setVisible(false);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.compositeSearchBar.getLastTextField().requestFocusInWindow();
        }
        this.cs.fireChange();
    }

    public CompositeSearchBar getCompositeSearchBar() {
        return this.compositeSearchBar;
    }

    void setSearchText(String text) {
        JTextField lastTextField = this.compositeSearchBar.getLastTextField();
        lastTextField.setText(text);
        lastTextField.selectAll();
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void hideFilterButton() {
        this.btnFilter.setVisible(false);
    }

    public boolean applyFiltering() {
        return this.applyFilter;
    }

    private void setCaseSensitive(Boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
        this.btnCase.setSelected(caseSensitive);
        this.btnCase.setToolTipText(caseSensitive != false ? "Switch to Case-Insensitive Search" : "Switch to Case-Sensitive Search");
        this.cs.fireChange();
    }

    private void setFilterStatus(Boolean filterStatus) {
        this.applyFilter = filterStatus;
        this.btnFilter.setSelected(filterStatus);
        this.btnFilter.setToolTipText(filterStatus != false ? "Remove filter" : "Apply filter");
        this.btnNext.setEnabled(this.applyFilter == false);
        this.btnPrev.setEnabled(this.applyFilter == false);
        this.cs.fireChange();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel(new FlowLayout(0, 3, 3));
        JLabel label = new JLabel("Find Text:");
        leftPanel.add(label);
        leftPanel.add(this.compositeSearchBar);
        this.compositeSearchBar.setVisible(true);
        this.btnPrev.setAction(SearchTextActions.FIND_PREV);
        this.btnPrev.setText("");
        this.btnPrev.setToolTipText("Find Previous Entry (Shift-ENTER)");
        this.btnPrev.setHideActionText(true);
        this.btnPrev.setIcon(UIUtils.loadIcon("/search/arrow_up.png"));
        leftPanel.add(UIUtils.autoScale(this.btnPrev));
        this.btnNext.setAction(SearchTextActions.FIND_NEXT);
        this.btnNext.setToolTipText("Find Next Entry (ENTER)");
        this.btnNext.setHideActionText(true);
        this.btnNext.setIcon(UIUtils.loadIcon("/search/arrow_down.png"));
        leftPanel.add(UIUtils.autoScale(this.btnNext));
        this.btnCase.setToolTipText("");
        this.btnCase.setHideActionText(true);
        this.btnCase.addActionListener(this::btnCaseActionPerformed);
        this.btnCase.setIcon(UIUtils.loadIcon("/search/case-sensitive.png"));
        leftPanel.add(UIUtils.autoScale(this.btnCase));
        this.btnFilter.setToolTipText("");
        this.btnFilter.setHideActionText(true);
        this.btnFilter.addActionListener(this::btnFilterActionPerformed);
        this.btnFilter.setIcon(UIUtils.loadIcon("/search/filter.png"));
        leftPanel.add(UIUtils.autoScale(this.btnFilter));
        leftPanel.add(this.progressBar);
        this.add((Component)leftPanel, "West");
        JButton btnCancel = new JButton();
        btnCancel.setToolTipText("Close Search Bar (Esc)");
        btnCancel.setContentAreaFilled(false);
        btnCancel.setPreferredSize(new Dimension(36, 32));
        btnCancel.addActionListener(this::btnCancelActionPerformed);
        btnCancel.setIcon(UIUtils.loadIcon("/search/close.png"));
        this.add((Component)UIUtils.autoScale(btnCancel), "East");
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.focusOwner.requestFocusInWindow();
    }

    private void btnCaseActionPerformed(ActionEvent evt) {
        this.setCaseSensitive(this.btnCase.isSelected());
    }

    private void btnFilterActionPerformed(ActionEvent actionEvent) {
        this.setFilterStatus(this.btnFilter.isSelected());
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    public List<Function<String, Boolean>> getSearchFilters() {
        return this.compositeSearchBar.getRowFilters();
    }

    public List<String[]> getSearchContext() {
        return this.compositeSearchBar.getSearchOpList();
    }
}

