/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.ui.ContentPanel;
import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.ui.ScrollBarUIEx;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.LogFilesModel;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogTimeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openide.util.Lookup;

public final class TimeAdjustmentPanel
extends ContentPanel {
    private final JTable table = new JTable();

    public TimeAdjustmentPanel() {
        super(Lookup.EMPTY);
        this.setLayout(new BorderLayout());
        this.table.setDefaultEditor(Object.class, null);
        final ListSelectionModel selectionModel = this.table.getSelectionModel();
        final AbstractAction editAction = new AbstractAction("Edit Start Time"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rows = TimeAdjustmentPanel.this.table.getRowCount();
                int firstSelected = TimeAdjustmentPanel.this.table.getSelectionModel().getMinSelectionIndex();
                LogModel logModel = (LogModel)TimeAdjustmentPanel.this.table.getModel().getValueAt(firstSelected, 0);
                LogTimeModel timeModel = logModel.lookup(LogTimeModel.class);
                AbsoluteTimestamp oldStartUTCTime = timeModel.getAbsoluteTimestampBase();
                String text = JOptionPane.showInputDialog(MainFrame.get(), "Enter Start Time: ", oldStartUTCTime.toString());
                if (text == null) {
                    return;
                }
                try {
                    AbsoluteTimestamp newStartUTCTime = AbsoluteTimestamp.parse(text);
                    for (int i = 0; i < rows; ++i) {
                        if (!selectionModel.isSelectedIndex(i)) continue;
                        logModel = (LogModel)TimeAdjustmentPanel.this.table.getModel().getValueAt(i, 0);
                        timeModel = logModel.lookup(LogTimeModel.class);
                        timeModel.setAbsoluteTimestampBase(newStartUTCTime);
                        MainFrame.get().refreshTimeModel();
                    }
                    TimeAdjustmentPanel.this.updateTableModel();
                }
                catch (ParseException ex) {
                    JOptionPane.showMessageDialog(TimeAdjustmentPanel.this, "Unable to parse date", "Error", 0);
                }
            }
        };
        AbstractAction copyAction = new AbstractAction("Copy Start Time"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int firstSelected = TimeAdjustmentPanel.this.table.getSelectionModel().getMinSelectionIndex();
                LogModel logModel = (LogModel)TimeAdjustmentPanel.this.table.getModel().getValueAt(firstSelected, 0);
                LogTimeModel timeModel = logModel.lookup(LogTimeModel.class);
                UIUtils.copyTextToClipboard(timeModel.getAbsoluteTimestampBase().toString());
            }
        };
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    editAction.actionPerformed(null);
                }
            }
        });
        selectionModel.addListSelectionListener(e -> {
            boolean enabled = !this.table.getSelectionModel().isSelectionEmpty();
            editAction.setEnabled(enabled);
            copyAction.setEnabled(enabled);
        });
        this.table.registerKeyboardAction(copyAction, KeyStroke.getKeyStroke(67, UIUtils.MENU_SHORTCUT_KEY_MASK, false), 1);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(copyAction));
        popupMenu.add(new JMenuItem(editAction));
        this.table.setComponentPopupMenu(popupMenu);
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof LogModel) {
                    value = ((LogModel)value).getLogName();
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.table.setAutoResizeMode(4);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(Color.WHITE);
        ScrollBarUIEx.setup(scrollPane, false);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public void addNotify() {
        this.updateTableModel();
        super.addNotify();
    }

    private void updateTableModel() {
        Object[] columnNames = new String[]{"Log Name", "UTC Start Time", "UTC End Time"};
        DefaultTableModel model = new DefaultTableModel(new Object[0][], columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        LogFilesModel models = Context.lookup(LogFilesModel.class);
        models.getLogFiles().stream().sorted(LogFilesModel::compare).forEach(f -> {
            LogModel logModel = f.lookup(LogModel.class);
            LogTimeModel timeModel = logModel.lookup(LogTimeModel.class);
            AbsoluteTimestamp utcStartTime = timeModel.getAbsoluteTimestampBase();
            model.addRow(new Object[]{logModel, utcStartTime.toString(), utcStartTime.shift(timeModel.getLastEventRelativeTimestamp())});
        });
        this.table.setModel(model);
    }
}

