/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.TimeRange;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.utils.UIUtils;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class TimeSelectionPanel
extends JPanel {
    private final Lookup.Result<TimeRangeSelectionModel.VisibleTimeRangeModel> visibleTimeRangeResult;
    private final TimeSelectionListener timeSelectionListener;
    private final MySpinnerModel startModel;
    private final MySpinnerModel endModel;
    private final JSpinner end = UIUtils.fixCopyPasteActionHotKeys(new JSpinner());
    private final JSpinner start = UIUtils.fixCopyPasteActionHotKeys(new JSpinner());
    private TimeRangeSelectionModel.VisibleTimeRangeModel timeRangeSelectionModel = null;

    public TimeSelectionPanel() {
        this.setLayout(new GridLayout(1, 3, 3, 0));
        this.add(new JLabel("Time selection (sec.):"));
        this.add(this.start);
        this.add(this.end);
        this.timeSelectionListener = new TimeSelectionListener();
        this.visibleTimeRangeResult = Context.lookupResult(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
        this.startModel = new MySpinnerModel();
        this.endModel = new MySpinnerModel();
        this.start.setModel(this.startModel);
        this.end.setModel(this.endModel);
        LookupListenerImpl lookupListener = new LookupListenerImpl();
        this.visibleTimeRangeResult.addLookupListener(lookupListener);
        lookupListener.resultChanged(null);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.registerListeners();
    }

    @Override
    public void removeNotify() {
        this.unregisterListeners();
        super.removeNotify();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.start.setEnabled(enabled);
        this.end.setEnabled(enabled);
    }

    private void registerListeners() {
        this.start.addChangeListener(this.timeSelectionListener);
        this.end.addChangeListener(this.timeSelectionListener);
    }

    private void unregisterListeners() {
        this.start.removeChangeListener(this.timeSelectionListener);
        this.end.removeChangeListener(this.timeSelectionListener);
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        @Override
        public void resultChanged(LookupEvent le) {
            if (TimeSelectionPanel.this.timeRangeSelectionModel != null) {
                TimeSelectionPanel.this.timeRangeSelectionModel.removeChangeListener(TimeSelectionPanel.this.timeSelectionListener);
            }
            TimeSelectionPanel.this.timeRangeSelectionModel = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
            if (TimeSelectionPanel.this.timeRangeSelectionModel != null) {
                TimeSelectionPanel.this.timeRangeSelectionModel.addChangeListener(TimeSelectionPanel.this.timeSelectionListener);
                TimeSelectionPanel.this.timeSelectionListener.stateChanged(new ChangeEvent(TimeSelectionPanel.this.timeRangeSelectionModel));
            }
        }
    }

    private final class TimeSelectionListener
    implements ChangeListener,
    FocusListener {
        private boolean allowNotify = true;

        private TimeSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            if (!this.allowNotify) {
                return;
            }
            if (TimeSelectionPanel.this.timeRangeSelectionModel.equals(e.getSource())) {
                this.allowNotify = false;
                try {
                    TimeRange ts = TimeSelectionPanel.this.timeRangeSelectionModel.getSelection();
                    TimeSelectionPanel.this.start.setValue((int)ts.getStart().getInUnits(TimeUnit.SECONDS));
                    TimeSelectionPanel.this.end.setValue((int)ts.getEnd().getInUnits(TimeUnit.SECONDS));
                }
                finally {
                    this.allowNotify = true;
                }
                return;
            }
            try {
                this.allowNotify = false;
                TimeRange ts = new TimeRange(((Number)TimeSelectionPanel.this.start.getValue()).longValue(), ((Number)TimeSelectionPanel.this.end.getValue()).longValue(), TimeUnit.SECONDS);
                TimeSelectionPanel.this.timeRangeSelectionModel.setSelection(ts);
            }
            finally {
                this.allowNotify = true;
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            SwingUtilities.invokeLater(() -> ((JTextField)e.getComponent()).selectAll());
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private final class MySpinnerModel
    extends SpinnerNumberModel {
        public MySpinnerModel() {
            this.setStepSize(10);
        }

        @Override
        public void setValue(Object value) {
            long val;
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException("illegal value");
            }
            TimeRangeSelectionModel.VisibleTimeRangeModel timeRangeSelectionModel = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
            if (timeRangeSelectionModel == null) {
                return;
            }
            long min = timeRangeSelectionModel.getMinimum(TimeUnit.SECONDS);
            long max = timeRangeSelectionModel.getMaximum(TimeUnit.SECONDS);
            long cstart = ((Number)TimeSelectionPanel.this.startModel.getValue()).longValue() + 1L;
            long cend = ((Number)TimeSelectionPanel.this.endModel.getValue()).longValue() - 1L;
            long newval = ((Number)value).longValue();
            if (this.equals(TimeSelectionPanel.this.startModel)) {
                val = Math.min(cend, newval);
                val = Math.max(min, val);
            } else {
                val = Math.max(cstart, newval);
                val = Math.min(max, val);
            }
            super.setValue(val);
        }
    }
}

