/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.ui.MainFrame;
import com.azul.log.gui.utils.UIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public final class TimeZonePicker {
    private TimeZonePicker() {
    }

    public static ZoneId selectZoneId() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Must be run in EDT");
        }
        final TimeZonePickerPanel picker = new TimeZonePickerPanel();
        JButton okButton = new JButton("OK");
        JOptionPane pane = new JOptionPane(picker, 1, 2, UIUtils.loadIcon("/timezone.png"), new Object[]{okButton, "Cancel"}, okButton){

            @Override
            public void selectInitialValue() {
                picker.inputField.requestFocus();
            }
        };
        picker.addPropertyChangeListener("zoneId", evt -> okButton.setEnabled(evt.getNewValue() != null));
        picker.addPropertyChangeListener("commitZoneId", evt -> pane.setValue(okButton));
        okButton.setEnabled(false);
        okButton.addActionListener(evt -> pane.setValue(okButton));
        pane.createDialog(MainFrame.get(), "Select Time Zone Region").setVisible(true);
        return pane.getValue() == okButton ? picker.zoneId : null;
    }

    private static final class TimeZonePickerPanel
    extends JPanel {
        private static final String PROPERTY_ZONE_ID = "zoneId";
        private static final String PROPERTY_COMMIT_ZONE_ID = "commitZoneId";
        private static final String FOCUS_INPUT_FIELD = "focusInputField";
        private final JTextField inputField = new JTextField();
        private final JTable timeZonesTable = new JTable(this.createModel());
        private ZoneId zoneId;
        private static final Map<String, String> aliasMap = Map.of("India Standard Time (IST)", "Asia/Kolkata", "China Standard Time (CST)", "Asia/Shanghai");

        private TimeZonePickerPanel() {
            JScrollPane scrollPane = new JScrollPane(this.timeZonesTable);
            this.inputField.setToolTipText("Time Zone Filter");
            this.inputField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent evt) {
                    timeZonesTable.getSelectionModel().clearSelection();
                    EventQueue.invokeLater(() -> timeZonesTable.getRowSorter().allRowsChanged());
                }
            });
            this.timeZonesTable.setDefaultEditor(Object.class, null);
            this.timeZonesTable.setTableHeader(null);
            this.timeZonesTable.setSelectionMode(0);
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.timeZonesTable.getModel());
            sorter.setRowFilter(new RowFilter<TableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                    return entry.getValue(0).toString().toLowerCase().contains(inputField.getText().toLowerCase());
                }
            });
            sorter.setSortKeys(List.of(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
            this.timeZonesTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        this.firePropertyChange(TimeZonePickerPanel.PROPERTY_COMMIT_ZONE_ID, null, zoneId);
                    }
                }
            });
            this.timeZonesTable.setRowSorter(sorter);
            this.timeZonesTable.getSelectionModel().addListSelectionListener(e -> {
                ZoneId oldZoneId = this.zoneId;
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.getValueIsAdjusting() || lsm.isSelectionEmpty()) {
                    this.zoneId = null;
                    this.firePropertyChange(PROPERTY_ZONE_ID, oldZoneId, null);
                    return;
                }
                int idx = sorter.convertRowIndexToModel(lsm.getMinSelectionIndex());
                this.zoneId = ((ZoneIdWithAlias)this.timeZonesTable.getModel().getValueAt(idx, 0)).getZoneId();
                this.firePropertyChange(PROPERTY_ZONE_ID, oldZoneId, this.zoneId);
                this.inputField.setText(this.zoneId.toString());
            });
            this.timeZonesTable.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ListSelectionModel sm;
                    if (zoneId == null && (sm = timeZonesTable.getSelectionModel()).isSelectionEmpty()) {
                        sm.setSelectionInterval(0, 0);
                    }
                }
            });
            this.inputField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    inputField.selectAll();
                }
            });
            InputMap im = this.timeZonesTable.getInputMap(1);
            im.put(KeyStroke.getKeyStroke(10, 0), "");
            im.put(KeyStroke.getKeyStroke(10, 64), "");
            im.put(KeyStroke.getKeyStroke(9, 0), FOCUS_INPUT_FIELD);
            im.put(KeyStroke.getKeyStroke(9, 64), FOCUS_INPUT_FIELD);
            this.timeZonesTable.getActionMap().put(FOCUS_INPUT_FIELD, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    inputField.requestFocus();
                }
            });
            scrollPane.getViewport().setBackground(Color.white);
            scrollPane.setVerticalScrollBarPolicy(22);
            this.setLayout(new BorderLayout());
            this.add((Component)this.inputField, "North");
            this.add((Component)scrollPane, "Center");
            this.doLayout();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.inputField.requestFocus();
        }

        private TableModel createModel() {
            LocalDateTime localDateTime = LocalDateTime.now();
            DefaultTableModel model = new DefaultTableModel(0, 2);
            ZoneId.getAvailableZoneIds().stream().map(zoneIdString -> new Object[]{ZoneIdWithAlias.of(zoneIdString), "UTC" + ZoneOffset.of(zoneIdString, Collections.emptyMap()).getRules().getOffset(localDateTime).toString().replace("Z", "+00:00")}).forEach(model::addRow);
            aliasMap.forEach((alias, zoneIdString) -> model.addRow(new Object[]{ZoneIdWithAlias.of(alias, zoneIdString), "UTC" + ZoneOffset.of(zoneIdString, Collections.emptyMap()).getRules().getOffset(localDateTime).toString().replace("Z", "+00:00")}));
            return model;
        }

        private static final class ZoneIdWithAlias {
            private final String alias;
            private final ZoneId zoneId;

            private ZoneIdWithAlias(String alias, ZoneId zoneId) {
                this.alias = alias;
                this.zoneId = zoneId;
            }

            public static ZoneIdWithAlias of(String zoneIdString) {
                ZoneId zId = ZoneId.of(zoneIdString);
                return new ZoneIdWithAlias(zId.toString(), zId);
            }

            public static ZoneIdWithAlias of(String alias, String zoneIdString) {
                return new ZoneIdWithAlias(alias, ZoneId.of(zoneIdString, aliasMap));
            }

            public ZoneId getZoneId() {
                return this.zoneId;
            }

            public String toString() {
                return this.alias;
            }
        }
    }
}

