/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.ui;

import com.azul.log.gui.actions.GoToNextViewAction;
import com.azul.log.gui.actions.GoToPrevViewAction;
import com.azul.log.gui.model.GraphsSelectorModel;
import com.azul.log.gui.model.RecentOpenFilesModel;
import com.azul.log.gui.ui.GraphSelectionPanel;
import com.azul.log.gui.ui.ToolbarButton;
import com.azul.log.gui.ui.ViewsNavigationHistory;
import com.azul.log.gui.utils.UIUtils;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class ViewsNavigationPanel
extends JPanel {
    public static final KeyStroke GO_TO_PREV_KEY = KeyStroke.getKeyStroke(37, UIUtils.MODIFIER_KEY_MASK);
    public static final KeyStroke GO_TO_NEXT_KEY = KeyStroke.getKeyStroke(39, UIUtils.MODIFIER_KEY_MASK);
    public static final int INFO_VIEW_ID = -1;
    public static final int LOG_VIEW_ID = -2;
    private static final GoToPrevViewAction goToPrevViewAction = new GoToPrevViewAction();
    private static final GoToNextViewAction goToNextViewAction = new GoToNextViewAction();
    private static final JButton goBackButton;
    private static final JButton goForwardButton;
    private static final ViewsNavigationPanel instance;
    private static final ViewsNavigationHistory viewsNavigationHistory;
    private static GraphSelectionPanel graphSelectionPanel;

    private ViewsNavigationPanel() {
        this.setLayout(new GridLayout(1, 2));
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.setPreferredSize(new Dimension(80, 44));
        UIUtils.autoScale(this);
        goBackButton.setEnabled(false);
        goForwardButton.setEnabled(false);
        this.add(goBackButton);
        this.add(goForwardButton);
        JMenuItem menuItem = new JMenuItem("Clear History");
        menuItem.addActionListener(action -> this.clearHistory());
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(menuItem);
        this.setComponentPopupMenu(popupMenu);
        GraphsSelectorModel.getModel().addChangeListener(e -> this.clearHistory());
        RecentOpenFilesModel.getModel().addChangeListener(e -> this.clearHistory());
    }

    public static ViewsNavigationPanel getInstance() {
        return instance;
    }

    public static GoToPrevViewAction getGoToPrevViewAction() {
        return goToPrevViewAction;
    }

    public static GoToNextViewAction getGoToNextViewAction() {
        return goToNextViewAction;
    }

    public static JButton getGoBackButton() {
        return goBackButton;
    }

    public static JButton getGoForwardButton() {
        return goForwardButton;
    }

    public static void graphSelectionChangeHandler() {
        if (graphSelectionPanel == null) {
            System.out.println("Graph Selection Panel has not been specified");
            return;
        }
        int selectedGraphRow = graphSelectionPanel.getCurrentSelectedRow();
        if (selectedGraphRow >= 0) {
            ViewsNavigationPanel.viewSelectionChangeHandler(selectedGraphRow);
        }
    }

    public static void infoViewSelectionHandler() {
        ViewsNavigationPanel.viewSelectionChangeHandler(-1);
    }

    public static void logViewSelectionHandler() {
        ViewsNavigationPanel.viewSelectionChangeHandler(-2);
    }

    private static void viewSelectionChangeHandler(int viewID) {
        try {
            if (goToPrevViewAction.isAllowedToPerform() && goToNextViewAction.isAllowedToPerform()) {
                viewsNavigationHistory.visit(viewID);
                if (viewsNavigationHistory.getBackStackSize() == 2) {
                    goBackButton.setEnabled(true);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void setGraphSelectionPanel(GraphSelectionPanel graphSelectionPanel) {
        ViewsNavigationPanel.graphSelectionPanel = graphSelectionPanel;
        goToPrevViewAction.setGraphSelectionPanel(graphSelectionPanel);
        goToNextViewAction.setGraphSelectionPanel(graphSelectionPanel);
    }

    public static void processNavigationMouseListener(MouseEvent mouseEvent) {
        switch (mouseEvent.getButton()) {
            case 4: 
            case 6: {
                ViewsNavigationPanel.getGoToPrevViewAction().actionPerformed(null);
                break;
            }
            case 5: 
            case 7: {
                ViewsNavigationPanel.getGoToNextViewAction().actionPerformed(null);
            }
        }
    }

    private void clearHistory() {
        goBackButton.setEnabled(false);
        goForwardButton.setEnabled(false);
        viewsNavigationHistory.clearHistory();
    }

    static {
        viewsNavigationHistory = ViewsNavigationHistory.getInstance();
        graphSelectionPanel = null;
        String goToPrevToolTip = "Go To Previous View (" + KeyEvent.getModifiersExText(UIUtils.MODIFIER_KEY_MASK) + "+" + KeyEvent.getKeyText(37) + ")";
        goBackButton = new ToolbarButton(goToPrevViewAction, goToPrevToolTip, "back");
        String goToNextToolTip = "Go To Next View (" + KeyEvent.getModifiersExText(UIUtils.MODIFIER_KEY_MASK) + "+" + KeyEvent.getKeyText(39) + ")";
        goForwardButton = new ToolbarButton(goToNextViewAction, goToNextToolTip, "forward");
        instance = new ViewsNavigationPanel();
    }
}

