/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.graphs.api.GraphDefinition;
import com.azul.log.gui.model.SelectionController;
import com.azul.log.gui.utils.jfreechart.JFreeChartRecordElement;

public final class JFreeChartElementSelectionController
extends SelectionController<JFreeChartRecordElement> {
    private final GraphDefinition graphDefinition;

    private JFreeChartElementSelectionController(GraphDefinition graphDefinition) {
        super(JFreeChartRecordElement.class);
        this.graphDefinition = graphDefinition;
    }

    static JFreeChartElementSelectionController get(GraphDefinition graphDefinition) {
        return new JFreeChartElementSelectionController(graphDefinition);
    }

    @Override
    public boolean hasNext(JFreeChartRecordElement element) {
        if (this.graphDefinition != element.graphDefinition) {
            return false;
        }
        return element.itemIndex < element.totalItems - 1;
    }

    @Override
    public boolean hasPrevious(JFreeChartRecordElement element) {
        if (this.graphDefinition != element.graphDefinition) {
            return false;
        }
        return element.itemIndex > 0;
    }

    @Override
    public JFreeChartRecordElement getPrevious(JFreeChartRecordElement element) {
        if (this.graphDefinition != element.graphDefinition) {
            return null;
        }
        return JFreeChartRecordElement.create(this.graphDefinition, element.seriesIndex, Math.max(0, element.itemIndex - 1), element.totalItems);
    }

    @Override
    public JFreeChartRecordElement getNext(JFreeChartRecordElement element) {
        if (this.graphDefinition != element.graphDefinition) {
            return null;
        }
        return JFreeChartRecordElement.create(this.graphDefinition, element.seriesIndex, Math.min(element.totalItems - 1, element.itemIndex + 1), element.totalItems);
    }
}

