/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.utils.jfreechart;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.DisplayTimeModel;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.utils.jfreechart.JFreeChartSupport;
import com.azul.log.gui.utils.jfreechart.NumberFormatEx;
import com.azul.log.model.api.RelativeTimestamp;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.FieldPosition;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.jfree.chart.axis.AxisLabelLocation;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.text.TextUtils;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.chart.util.Args;
import org.jfree.data.Range;

final class NumberAxisEx
extends NumberAxis {
    private Shape labelArea = new Rectangle();

    public NumberAxisEx() {
        DisplayTimeModel dtm;
        DisplayTimeModel.Units units;
        TimeRangeSelectionModel.VisibleTimeRangeModel model = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
        if (model != null) {
            this.setRange(JFreeChartSupport.toJFCRange(model.getSelection(), TimeUnit.NANOSECONDS));
        }
        if ((units = (dtm = Context.lookup(DisplayTimeModel.class)).getUnits()) == DisplayTimeModel.Units.ABSOLUTE || units == DisplayTimeModel.Units.AUTO) {
            if (DisplayTimeModel.Units.AUTO == units) {
                this.setLabel("Elapsed Time (" + units.getDescription() + ")");
            } else {
                this.setLabel(dtm.getTZone().getDescription());
            }
            this.setVerticalTickLabels(true);
            final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM dd HH:mm:ss.SSS");
            this.setNumberFormatOverride(new NumberFormatEx(){

                @Override
                public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
                    RelativeTimestamp ts = RelativeTimestamp.of(number, TimeUnit.NANOSECONDS);
                    return toAppendTo.append(dtm.toString(ts, formatter));
                }
            });
        } else {
            this.setLabel("Elapsed Time (" + units.getDescription() + ")");
            this.setVerticalTickLabels(false);
            this.setStandardTickUnits(new TickUnitSourceImpl(units));
        }
        this.setLabelInsets(new RectangleInsets(8.0, 3.0, 0.0, 3.0));
    }

    Shape getLabelBounds() {
        return this.labelArea;
    }

    @Override
    protected AxisState drawLabel(String label, Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, AxisState state) {
        AffineTransform t;
        Args.nullNotPermitted(state, "state");
        if (label == null || ((String)label).equals("")) {
            return state;
        }
        label = (String)label + " \u25be";
        Font font = this.getLabelFont();
        RectangleInsets insets = this.getLabelInsets();
        g2.setFont(font);
        g2.setPaint(this.getLabelPaint());
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D labelBounds = TextUtils.getTextBounds((String)label, g2, fm);
        AxisLabelLocation labelLocation = this.getLabelLocation();
        if (edge == RectangleEdge.TOP) {
            t = AffineTransform.getRotateInstance(this.getLabelAngle(), labelBounds.getCenterX(), labelBounds.getCenterY());
            Shape rotatedLabelBounds = t.createTransformedShape(labelBounds);
            labelBounds = rotatedLabelBounds.getBounds2D();
            double labelx = this.labelLocationX(labelLocation, plotArea);
            double labely = state.getCursor() - insets.getBottom() - labelBounds.getHeight() / 2.0;
            TextAnchor anchor = this.labelAnchorH(labelLocation);
            TextUtils.drawRotatedString((String)label, g2, (float)labelx, (float)labely, anchor, this.getLabelAngle(), TextAnchor.CENTER);
            state.cursorUp(insets.getTop() + labelBounds.getHeight() + insets.getBottom());
            this.labelArea = TextUtils.calculateRotatedStringBounds((String)label, g2, (float)labelx, (float)labely, anchor, this.getLabelAngle(), TextAnchor.CENTER);
        } else if (edge == RectangleEdge.BOTTOM) {
            t = AffineTransform.getRotateInstance(this.getLabelAngle(), labelBounds.getCenterX(), labelBounds.getCenterY());
            Shape rotatedLabelBounds = t.createTransformedShape(labelBounds);
            labelBounds = rotatedLabelBounds.getBounds2D();
            double labelx = this.labelLocationX(labelLocation, plotArea);
            double labely = state.getCursor() + insets.getTop() + labelBounds.getHeight() / 2.0;
            TextAnchor anchor = this.labelAnchorH(labelLocation);
            TextUtils.drawRotatedString((String)label, g2, (float)labelx, (float)labely, anchor, this.getLabelAngle(), TextAnchor.CENTER);
            state.cursorDown(insets.getTop() + labelBounds.getHeight() + insets.getBottom());
            this.labelArea = TextUtils.calculateRotatedStringBounds((String)label, g2, (float)labelx, (float)labely, anchor, this.getLabelAngle(), TextAnchor.CENTER);
        } else if (edge == RectangleEdge.LEFT) {
            t = AffineTransform.getRotateInstance(this.getLabelAngle() - 1.5707963267948966, labelBounds.getCenterX(), labelBounds.getCenterY());
            Shape rotatedLabelBounds = t.createTransformedShape(labelBounds);
            labelBounds = rotatedLabelBounds.getBounds2D();
            double labelx = state.getCursor() - insets.getRight() - labelBounds.getWidth() / 2.0;
            double labely = this.labelLocationY(labelLocation, plotArea);
            TextAnchor anchor = this.labelAnchorV(labelLocation);
            TextUtils.drawRotatedString((String)label, g2, (float)labelx, (float)labely, anchor, this.getLabelAngle() - 1.5707963267948966, anchor);
            state.cursorLeft(insets.getLeft() + labelBounds.getWidth() + insets.getRight());
            this.labelArea = TextUtils.calculateRotatedStringBounds((String)label, g2, (float)labelx, (float)labely, anchor, this.getLabelAngle() - 1.5707963267948966, anchor);
        } else if (edge == RectangleEdge.RIGHT) {
            t = AffineTransform.getRotateInstance(this.getLabelAngle() + 1.5707963267948966, labelBounds.getCenterX(), labelBounds.getCenterY());
            Shape rotatedLabelBounds = t.createTransformedShape(labelBounds);
            labelBounds = rotatedLabelBounds.getBounds2D();
            double labelx = state.getCursor() + insets.getLeft() + labelBounds.getWidth() / 2.0;
            double labely = this.labelLocationY(labelLocation, plotArea);
            TextAnchor anchor = this.labelAnchorV(labelLocation);
            TextUtils.drawRotatedString((String)label, g2, (float)labelx, (float)labely, anchor, this.getLabelAngle() + 1.5707963267948966, anchor);
            state.cursorRight(insets.getLeft() + labelBounds.getWidth() + insets.getRight());
            this.labelArea = TextUtils.calculateRotatedStringBounds((String)label, g2, (float)labelx, (float)labely, anchor, this.getLabelAngle() + 1.5707963267948966, anchor);
        }
        AffineTransform transform = g2.getTransform();
        this.labelArea = transform == null ? this.labelArea : transform.createTransformedShape(this.labelArea);
        return state;
    }

    @Override
    public void setRange(Range range) {
        if (range.getLength() > 0.0) {
            super.setRange(range);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NumberAxisEx && super.equals(obj);
    }

    private static class TickUnitSourceImpl
    implements TickUnitSource {
        private final NumberTickUnitSource numberTickUnitSource = new NumberTickUnitSource();
        private final TimeUnit units;

        public TickUnitSourceImpl(DisplayTimeModel.Units units) {
            this.units = units.toTimeUnit();
        }

        @Override
        public TickUnit getLargerTickUnit(TickUnit tu) {
            double ns = tu.getSize();
            final long factor = this.units.toNanos(1L);
            final TickUnit u = this.numberTickUnitSource.getLargerTickUnit(new NumberTickUnit(ns / (double)factor));
            return new NumberTickUnit(u.getSize() * (double)factor, new NumberFormatEx(){

                @Override
                public StringBuffer format(double ns, StringBuffer toAppendTo, FieldPosition pos) {
                    double size = u.getSize();
                    double val = ns / (double)factor;
                    return toAppendTo.append(this.formatNumberForUnitSize(val, size)).append("  ");
                }
            }, u.getMinorTickCount());
        }

        @Override
        public TickUnit getCeilingTickUnit(TickUnit tu) {
            return this.getCeilingTickUnit(tu.getSize());
        }

        @Override
        public TickUnit getCeilingTickUnit(double ns) {
            final long factor = this.units.toNanos(1L);
            final TickUnit u = this.numberTickUnitSource.getCeilingTickUnit(ns / (double)factor);
            return new NumberTickUnit(u.getSize() * (double)factor, new NumberFormatEx(){

                @Override
                public StringBuffer format(double ns, StringBuffer toAppendTo, FieldPosition pos) {
                    double size = u.getSize();
                    double val = ns / (double)factor;
                    return toAppendTo.append(this.formatNumberForUnitSize(val, size)).append("  ");
                }
            }, u.getMinorTickCount());
        }
    }
}

