/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.model.api;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.utils.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public final class AbsoluteTimestamp
implements Comparable<AbsoluteTimestamp> {
    private static final Map<String, SimpleDateFormat> formats = new HashMap<String, SimpleDateFormat>();
    private final long ms;
    private static final String[][] timestampFormats = new String[][]{new String[0], {"yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mm:ss.SSS"}, {"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss"}, new String[0], new String[0], new String[0], {"EEE MMM dd HH:mm:ss zzz yyyy", "EEE MMM dd HH:mm:ss X yyyy"}, {"EEE MMM dd HH:mm:ss aa zzz yyyy", "EEE MMM dd HH:mm:ss aa X yyyy"}};
    private static String lastUsedFormat = timestampFormats[1][0];

    private AbsoluteTimestamp(long ms) {
        this.ms = ms;
    }

    public static AbsoluteTimestamp of(double ts, LogUnits timeUnit) {
        return new AbsoluteTimestamp((long)timeUnit.convertTo(ts, LogUnits.MILLISECONDS));
    }

    public static AbsoluteTimestamp of(double ts, TimeUnit timeUnit) {
        return AbsoluteTimestamp.of(ts, LogUnits.of(timeUnit));
    }

    public AbsoluteTimestamp shift(double delta, LogUnits timeUnit) {
        return AbsoluteTimestamp.of((double)this.ms + timeUnit.convertTo(delta, LogUnits.MILLISECONDS), LogUnits.MILLISECONDS);
    }

    public AbsoluteTimestamp shift(double delta, TimeUnit timeUnit) {
        return this.shift(delta, LogUnits.of(timeUnit));
    }

    public AbsoluteTimestamp shift(RelativeTimestamp relativeTimestamp) {
        return this.shift(relativeTimestamp.getInUnits(LogUnits.NANOSECONDS), LogUnits.of(TimeUnit.NANOSECONDS));
    }

    public static double delta(AbsoluteTimestamp first, AbsoluteTimestamp second, LogUnits timeUnit) {
        return LogUnits.MILLISECONDS.convertTo(first.ms - second.ms, timeUnit);
    }

    public static double delta(AbsoluteTimestamp first, AbsoluteTimestamp second, TimeUnit timeUnit) {
        return AbsoluteTimestamp.delta(first, second, LogUnits.of(timeUnit));
    }

    public static AbsoluteTimestamp parse(CharSequence string) throws ParseException {
        try {
            return AbsoluteTimestamp.parse(string.toString(), lastUsedFormat);
        }
        catch (ParseException parseException) {
            int words = 1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ' ' || words++ < timestampFormats.length) continue;
                throw new ParseException("Unknown format", 0);
            }
            if (timestampFormats[words].length > 0) {
                try {
                    AbsoluteTimestamp result = AbsoluteTimestamp.parse(string.toString(), timestampFormats[words][0]);
                    lastUsedFormat = timestampFormats[words][0];
                    return result;
                }
                catch (ParseException ex) {
                    for (int i = 1; i < timestampFormats[words].length; ++i) {
                        try {
                            String fmt = timestampFormats[words][i];
                            AbsoluteTimestamp result = AbsoluteTimestamp.parse(string.toString(), fmt);
                            AbsoluteTimestamp.timestampFormats[words][i] = timestampFormats[words][0];
                            AbsoluteTimestamp.timestampFormats[words][0] = fmt;
                            lastUsedFormat = fmt;
                            return result;
                        }
                        catch (ParseException parseException2) {
                            continue;
                        }
                    }
                }
            }
            throw new ParseException("Unknown format", 0);
        }
    }

    public static AbsoluteTimestamp parse(CharSequence string, LogUnits timeUnits) throws ParseException {
        char c;
        int i;
        for (i = 0; i < string.length() && (Character.isDigit(c = string.charAt(i)) || '.' == c || ',' == c); ++i) {
        }
        try {
            Double val = TextUtils.parseDouble(string.subSequence(0, i));
            if (val != null) {
                return AbsoluteTimestamp.of((double)val, timeUnits);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new ParseException("Unable to parse timestamp ->" + string + "<-", i);
    }

    private static AbsoluteTimestamp parse(String string, String format) throws ParseException {
        SimpleDateFormat parser = formats.computeIfAbsent(format, SimpleDateFormat::new);
        parser.setTimeZone(TimeZone.getTimeZone(ZoneId.of("UTC")));
        Date date = parser.parse(string);
        return AbsoluteTimestamp.of((double)date.getTime(), LogUnits.MILLISECONDS);
    }

    public long toEpochTime() {
        return this.ms;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbsoluteTimestamp) {
            AbsoluteTimestamp that = (AbsoluteTimestamp)obj;
            return this.ms == that.ms;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (int)(this.ms ^ this.ms >>> 32);
        return hash;
    }

    @Override
    public int compareTo(AbsoluteTimestamp o) {
        return Long.compare(this.ms, o.ms);
    }

    public String toString(DateTimeFormatter formatter, ZoneId zoneId) {
        Instant instant = new Date(this.ms).toInstant();
        return instant.atZone(zoneId).format(formatter);
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone(ZoneId.of("UTC")));
        return sdf.format(new Date(this.toEpochTime()));
    }
}

