/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.model.api;

import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogRecordsMap;
import com.azul.log.model.api.LogSecondsToLineNumberMap;
import com.azul.log.parser.api.LogLineWithTime;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;

public abstract class LogModel {
    private final LogRecordsMap recordsMap = new LogRecordsMap();
    private final LogSecondsToLineNumberMap secondsToFirstVisibleLogLineMap = new LogSecondsToLineNumberMap();
    private final String modelId;
    private String name;
    private long size;
    private long timeAdjustmentNano;
    private LogFile logFile;
    private long logFileDigest;

    protected LogModel(String modelId) {
        this.modelId = modelId;
    }

    public String getModelID() {
        return this.modelId;
    }

    public long getTimeAdjustmentNano() {
        return this.timeAdjustmentNano;
    }

    public void setTimeAdjustmentNano(long timeAdjustmentNano) {
        this.timeAdjustmentNano = timeAdjustmentNano;
    }

    public LogRecordsMap getRecordsMap() {
        return this.recordsMap;
    }

    public final String getLogName() {
        if (this.name == null) {
            this.name = this.calculateLogName();
        }
        return this.name;
    }

    public final long getLogSize() throws IOException {
        if (this.size == 0L) {
            this.size = this.calculateLogSize();
        }
        return this.size;
    }

    public String getLogUID() {
        return Long.toHexString(this.logFileDigest);
    }

    public abstract InputStream newInputStream() throws IOException;

    public abstract List<Path> getPaths();

    protected abstract String calculateLogName();

    protected abstract long calculateLogSize() throws IOException;

    void setLogFile(LogFile logFile, long logFileDigest) {
        this.logFile = logFile;
        this.logFileDigest = logFileDigest;
    }

    public <T> T lookup(Class<T> klass) {
        return this.logFile == null ? null : (T)this.logFile.lookup(klass);
    }

    public void recordLogLineStartTimes(int lineNumber, LogLineWithTime logLineWithTime) {
        this.secondsToFirstVisibleLogLineMap.add(lineNumber, logLineWithTime.getRelativeTimestamp());
    }

    public int getClosestMatchingLogLineForGivenTime(long elapsedTimeInSec) {
        if (elapsedTimeInSec > this.secondsToFirstVisibleLogLineMap.getLastSuccessfullyTrackedElapsedTime()) {
            return Integer.MAX_VALUE;
        }
        return (Integer)this.secondsToFirstVisibleLogLineMap.get(elapsedTimeInSec);
    }
}

