/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.model.api;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.spi.LogDataAggregator;
import com.azul.log.model.spi.LogDataConverter;
import com.azul.log.parser.api.Aggregation;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

public class LogRecordsList<T extends LogRecord>
implements Iterable<T> {
    private static final LogRecordsList<LogRecord> EMPTY = new LogRecordsList<LogRecord>(null, null){

        @Override
        public void add(LogRecord record) {
            throw new IllegalAccessError();
        }
    };
    private static final int LOG = 12;
    private static final int BUCKET_SIZE = 4096;
    private static final int IDX_MASK = 4095;
    private final List<LogRecord[]> list = new ArrayList<LogRecord[]>();
    private final List<Double> aggregatedValues = new ArrayList<Double>();
    private final LogDataAggregator aggregator;
    private final LogDataConverter converter;
    private LogRecord[] bucket = null;
    private int bucket_idx = 4096;
    private int total_size = 0;

    public LogRecordsList(LogDataAggregator aggregator, LogDataConverter converter) {
        this.aggregator = aggregator;
        this.converter = converter;
    }

    public static <T extends LogRecord> LogRecordsList<T> emptyList() {
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(T record) {
        List<LogRecord[]> list = this.list;
        synchronized (list) {
            if (this.bucket_idx == 4096) {
                this.bucket = new LogRecord[4096];
                this.list.add(this.bucket);
                this.bucket_idx = 0;
            }
            this.bucket[this.bucket_idx++] = record;
            ++this.total_size;
            if (this.aggregator != null) {
                this.aggregatedValues.add(this.aggregator.aggregate((LogRecord)record, this.converter));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogRecordsIterator<T> iterator() {
        int size_total;
        List<LogRecord[]> list = this.list;
        synchronized (list) {
            size_total = this.total_size;
        }
        return new LogRecordsIterator<T>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < size_total;
            }

            @Override
            public T next() {
                if (size_total != LogRecordsList.this.total_size) {
                    throw new ConcurrentModificationException();
                }
                return LogRecordsList.this.get(this.idx++);
            }

            @Override
            public Double getAggregatedValue() {
                return LogRecordsList.this.getAggregatedValue(this.idx - 1);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List<LogRecord[]> list = this.list;
        synchronized (list) {
            return this.list.isEmpty();
        }
    }

    public boolean hasData() {
        return !this.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int idx) {
        List<LogRecord[]> list = this.list;
        synchronized (list) {
            LogRecord[] b = this.list.get(idx >> 12);
            return (T)b[idx & 0xFFF];
        }
    }

    public Aggregation getAggregation() {
        return this.aggregator == null ? Aggregation.UNSPECIFIED : this.aggregator.getAggregation();
    }

    public Double getAggregatedValue(int idx) {
        return this.aggregator == null ? null : this.aggregatedValues.get(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<LogRecord[]> list = this.list;
        synchronized (list) {
            return this.total_size;
        }
    }

    public static interface LogRecordsIterator<T>
    extends Iterator<T> {
        public Double getAggregatedValue();
    }
}

