/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.model.api;

import com.azul.log.model.api.RelativeTimestamp;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class LogSecondsToLineNumberMap
extends HashMap<Long, Integer> {
    private long prevSuccessfullyTrackedElapsedTime = 0L;

    public LogSecondsToLineNumberMap() {
        this.putIfAbsent(0L, 0);
    }

    public void add(int lineNumber, RelativeTimestamp logLineRelativeTimeStamp) {
        if (Objects.nonNull(logLineRelativeTimeStamp)) {
            long currSuccessfullyTrackedElapsedTime = logLineRelativeTimeStamp.getInUnits(TimeUnit.SECONDS);
            if (currSuccessfullyTrackedElapsedTime == this.prevSuccessfullyTrackedElapsedTime) {
                return;
            }
            this.putIfAbsent(currSuccessfullyTrackedElapsedTime, lineNumber);
            for (long i = this.prevSuccessfullyTrackedElapsedTime + 1L; i < currSuccessfullyTrackedElapsedTime; ++i) {
                this.putIfAbsent(i, (Integer)this.get(this.prevSuccessfullyTrackedElapsedTime));
            }
            if (currSuccessfullyTrackedElapsedTime > this.prevSuccessfullyTrackedElapsedTime) {
                this.prevSuccessfullyTrackedElapsedTime = currSuccessfullyTrackedElapsedTime;
            }
        }
    }

    public long getLastSuccessfullyTrackedElapsedTime() {
        return this.prevSuccessfullyTrackedElapsedTime;
    }
}

