/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.api;

import com.azul.log.model.api.LogFile;
import com.azul.log.model.api.LogModel;
import com.azul.log.parser.spi.LogStreamHandler;
import com.azul.log.parser.spi.ParserExceptionHandler;
import com.azul.log.parser.spi.ParserFetcher;
import com.azul.log.parser.spi.UserInteractionHandler;
import com.azul.log.utils.ProgressModel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openide.util.Lookup;

public abstract class LogParserBase {
    final List<LogStreamHandler> streamHandlers = new ArrayList<LogStreamHandler>();
    final List<ParserExceptionHandler> exceptionHandlers = new ArrayList<ParserExceptionHandler>();

    public abstract LogFile parse(ProgressModel var1) throws IOException;

    public void addParserExceptionHandler(ParserExceptionHandler handler) {
        this.exceptionHandlers.add(handler);
    }

    public void addStreamHandler(LogStreamHandler handler) {
        this.streamHandlers.add(handler);
    }

    public abstract LogModel getModel();

    public static LogParserBase getParserFor(Path path, UserInteractionHandler ui) throws IOException {
        Optional<LogParserBase> parser;
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException(path + " not found");
        }
        if (!Files.isReadable(path)) {
            throw new IOException(path + " is not readable");
        }
        if (!path.toFile().isFile()) {
            throw new IOException(path + " is not a regular file");
        }
        Collection<ParserFetcher> parserFetchers = Lookup.getDefault().lookupAll(ParserFetcher.class);
        if (!parserFetchers.isEmpty() && (parser = parserFetchers.stream().sorted().map(parserFetcher -> parserFetcher.fetchParser(path, ui)).filter(Objects::nonNull).findFirst()).isPresent()) {
            return parser.get();
        }
        return null;
    }
}

