/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.api;

import com.azul.log.model.api.LogModel;
import com.azul.log.utils.ProgressModel;
import com.azul.log.utils.ProgressMonitorInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public final class LogReader
implements AutoCloseable {
    private static final int BUFFER_SIZE = 16384;
    private final Checksum checksum = new Adler32();
    private final char[] buffer = new char[16384];
    private final StringBuilder currentLine = new StringBuilder();
    private final Reader reader;
    private boolean eos = false;
    private int lineNumber = 0;
    private long charsRead = 0L;
    private long charsBufferedTo = 0L;
    private long charsBufferedFrom = 0L;
    private long digest;

    private LogReader(InputStream inputStream) {
        this.reader = new InputStreamReader(inputStream);
    }

    public static LogReader create(LogModel model, ProgressModel progress) throws IOException {
        return progress == null ? new LogReader(model.newInputStream()) : new LogReader(new ProgressMonitorInputStream(progress, model.newInputStream(), model.getLogSize()));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public int currentLineNumber() {
        return this.lineNumber;
    }

    public long getDigest() {
        return this.digest;
    }

    public String readLine() throws IOException {
        if (this.eos) {
            return null;
        }
        this.currentLine.setLength(0);
        while (!this.eos) {
            char c;
            if (this.charsRead >= this.charsBufferedTo) {
                this.charsBufferedFrom = this.charsBufferedTo;
                int read = this.reader.read(this.buffer, 0, 16384);
                if (read == -1) {
                    this.eos = true;
                }
                this.charsBufferedTo += (long)read;
            }
            char c2 = c = this.eos ? (char)'\n' : this.buffer[(int)(this.charsRead++ - this.charsBufferedFrom)];
            if (c == '\n') {
                ++this.lineNumber;
                if (this.eos && this.currentLine.length() == 0) continue;
                String line = this.currentLine.toString();
                if (!line.isEmpty() && this.currentLine.charAt(0) != '#') {
                    this.checksum.update(line.getBytes(), 0, line.length());
                }
                return line;
            }
            this.currentLine.append(c);
        }
        this.currentLine.setLength(0);
        this.digest = this.checksum.getValue();
        return null;
    }
}

