/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4;

import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_DataLineParser;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class C4_DoubleHeaderDataParser<R extends C4_LogRecord>
extends C4_DataLineParser<R> {
    private String firstHeaderLine;
    private String secondHeaderLine;
    private int line = 0;

    public C4_DoubleHeaderDataParser(Class<R> klass) {
        super(klass);
    }

    @Override
    public final Collection<String> getPrefixes() {
        return Arrays.asList(this.header_marker, this.data_marker);
    }

    protected Map<String, String> getKnownHeaderSections() {
        return Collections.emptyMap();
    }

    @Override
    protected boolean parseHeaderImpl(String header) throws ParserException {
        header = header.replaceAll("\\s*]\\s*$", "");
        if (this.line == 0) {
            this.firstHeaderLine = header;
        } else {
            String[] fixup;
            this.secondHeaderLine = header;
            String[] fixedHeaders = this.fixHeaderMisalignment(this.firstHeaderLine, this.secondHeaderLine);
            if (fixedHeaders.length == 2) {
                this.firstHeaderLine = fixedHeaders[0];
                this.secondHeaderLine = fixedHeaders[1];
            }
            if ((fixup = this.getFirstLineFixupMatrix()) != null) {
                for (int i = 0; i < fixup.length; i += 3) {
                    if (!fixup[i].equals(this.firstHeaderLine) || !fixup[i + 1].equals(this.secondHeaderLine)) continue;
                    this.firstHeaderLine = fixup[i + 2];
                    break;
                }
            }
            ArrayList<Integer> groups_start_pos = new ArrayList<Integer>();
            ArrayList<String> groups = new ArrayList<String>();
            ArrayList<Field> header_arr = new ArrayList<Field>();
            int group_start_pos = 0;
            Pattern p = Pattern.compile("[ :]+[ :]+");
            Matcher m = p.matcher(this.firstHeaderLine);
            groups_start_pos.add(group_start_pos);
            while (m.find()) {
                groups.add(this.firstHeaderLine.substring(group_start_pos, m.start()));
                group_start_pos = m.end();
                groups_start_pos.add(group_start_pos);
            }
            groups.add(this.firstHeaderLine.substring(group_start_pos));
            groups_start_pos.add(this.secondHeaderLine.length());
            StringBuilder sb = new StringBuilder();
            int group = 0;
            p = Pattern.compile("[^ ]+");
            m = p.matcher(this.secondHeaderLine);
            sb.append((String)groups.get(group));
            if (sb.length() > 0) {
                sb.append('#');
            }
            int group_len = sb.length();
            while (m.find()) {
                if (m.group().equals(":")) {
                    header_arr.add(null);
                    continue;
                }
                if (m.start() >= (Integer)groups_start_pos.get(group + 1)) {
                    sb.setLength(0);
                    sb.append((String)groups.get(++group)).append('#');
                    group_len = sb.length();
                }
                sb.setLength(group_len);
                sb.append(this.secondHeaderLine, m.start(), m.end());
                String key = sb.toString();
                if (this.hdr_to_fld.containsKey(key)) {
                    header_arr.add((Field)this.hdr_to_fld.get(key));
                    continue;
                }
                Logger.getLogger(C4_DoubleHeaderDataParser.class.getName()).log(Level.FINE, "Warning: field " + key + " is unknown!");
                header_arr.add(null);
            }
            this.defineFields(header_arr);
        }
        this.line = (this.line + 1) % 2;
        return true;
    }

    private String[] fixHeaderMisalignment(String firstHeader, String secondHeader) {
        List<Integer> secondHeaderColonPositions;
        String[] EMPTY_RESULT = new String[]{};
        List<Integer> firstHeaderColonPostions = StringUtils.getPositionsOfCharInString(firstHeader, ':');
        if (firstHeaderColonPostions.equals(secondHeaderColonPositions = StringUtils.getPositionsOfCharInString(secondHeader, ':'))) {
            return EMPTY_RESULT;
        }
        if (firstHeaderColonPostions.size() != secondHeaderColonPositions.size()) {
            return EMPTY_RESULT;
        }
        String[] firstHeaderSections = firstHeader.split(":");
        String[] secondHeaderSections = secondHeader.split(":");
        ArrayList<String> firstHeaderSectionsFixed = new ArrayList<String>();
        ArrayList<String> secondHeaderSectionsFixed = new ArrayList<String>();
        for (int i = 0; i < firstHeaderSections.length - 1; ++i) {
            String curSectionFromFirstHeader = firstHeaderSections[i];
            String currSectionFromSecondHeader = secondHeaderSections[i];
            Map<String, String> knownHeaderSections = this.getKnownHeaderSections();
            Optional<Map.Entry> matchedEntry = knownHeaderSections.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreSpace(curSectionFromFirstHeader, (String)entry.getKey())).findFirst();
            if (matchedEntry.isPresent()) {
                Map.Entry entry2 = matchedEntry.get();
                firstHeaderSectionsFixed.add((String)entry2.getKey());
                secondHeaderSectionsFixed.add((String)entry2.getValue());
                continue;
            }
            int maxSectionLength = Math.max(curSectionFromFirstHeader.length(), currSectionFromSecondHeader.length());
            String format = "%-" + maxSectionLength + "s";
            firstHeaderSectionsFixed.add(String.format(format, curSectionFromFirstHeader));
            secondHeaderSectionsFixed.add(String.format(format, currSectionFromSecondHeader));
        }
        int lastIndex = firstHeaderSections.length - 1;
        if (lastIndex >= 0) {
            firstHeaderSectionsFixed.add(firstHeaderSections[lastIndex]);
            secondHeaderSectionsFixed.add(secondHeaderSections[lastIndex]);
        }
        String firstHeaderFixed = String.join((CharSequence)":", firstHeaderSectionsFixed);
        String secondHeaderFixed = String.join((CharSequence)":", secondHeaderSectionsFixed);
        return new String[]{firstHeaderFixed, secondHeaderFixed};
    }
}

