/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.advisor;

import com.azul.log.advisor.api.Advice;
import com.azul.log.advisor.api.Advices;
import com.azul.log.advisor.spi.AdvicesProvider;
import com.azul.log.model.api.LogModel;
import com.azul.log.parser.impl.c4.advisor.RecordFilters;
import com.azul.log.parser.impl.c4.advisor.StatsProvider;
import com.azul.log.parser.impl.c4.advisor.VMFlagsDependencyInfo;
import com.azul.log.parser.impl.c4.advisor.utils.Utils;
import com.azul.log.parser.impl.c4.records.C4_LogHeader;
import com.azul.log.parser.impl.c4.records.GCRecord;
import com.azul.log.parser.impl.c4.records.ProfstatsRecord;
import com.azul.log.parser.impl.c4.records.SafepointRecord;
import com.azul.log.parser.impl.c4.records.SysinfoRecord;
import com.azul.log.parser.impl.c4.records.VmaCountersRecord;
import com.azul.log.utils.TextToHTML;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openide.util.Lookup;

public final class C4_LogAnalysisProvider
implements AdvicesProvider {
    private static final int recommendedMinFreeKBytes = 0x100000;
    private static final int recommendedVMASize = 1000000;

    @Override
    public boolean canHandle(String logModelID) {
        return "C4".equals(logModelID);
    }

    @Override
    public Advices process(LogModel model, Lookup parserLookup) {
        Advices advices = new Advices();
        C4_LogHeader headers = parserLookup.lookup(C4_LogHeader.class);
        VMFlagsDependencyInfo vmFlagsDependencyInfo = VMFlagsDependencyInfo.create(headers.jvm_arguments);
        for (String vmFlag : vmFlagsDependencyInfo.getVMFlagsOnCmdLineAsList()) {
            List<String> missingDepenentFlags = vmFlagsDependencyInfo.getMissingDependentsFor(vmFlag);
            if (missingDepenentFlags.isEmpty()) continue;
            advices.add((rangeStart, rangeEnd) -> Optional.of(new Advice("Missing dependent options for " + vmFlag, String.format("Option %s is set, but its dependent option(s) %s are missing\n", TextToHTML.toItalic(vmFlag), TextToHTML.toItalic(missingDepenentFlags.toString())), Advice.Severity.L1, null, null)));
        }
        Utils.getInt(headers.sys_data, "/proc/sys/vm/min_free_kbytes").filter(val -> val < 0x100000).ifPresent(val -> advices.add((rangeStart, rangeEnd) -> Optional.of(new Advice("Current setting of min_free_kbytes is too low (" + val + ")", "Consider increasing the setting to at least 1048576 by doing: \n'" + TextToHTML.toItalic("echo 1048576 > /proc/sys/vm/min_free_kbytes") + "' as root", Advice.Severity.L2, "https://linuxhint.com/vm_min_free_kbytes_sysctl", "" + headers.sys_data.get((Object)"/proc/sys/vm/min_free_kbytes").lineNumber))));
        Optional<List<String>> availableClockSources = Utils.getStringList(headers.sys_data, "/sys/devices/system/clocksource/clocksource0/available_clocksource");
        Utils.getString(headers.sys_data, "/sys/devices/system/clocksource/clocksource0/current_clocksource").filter(src -> !src.equals("tsc") && availableClockSources.filter(val -> val.contains("tsc")).isPresent()).ifPresent(src -> advices.add((rangeStart, rangeEnd) -> Optional.of(new Advice("Current setting of clock source is '" + src + "'", "Consider changing the clock source to 'tsc' by doing: \n'" + TextToHTML.toItalic("echo \"tsc\" > /sys/devices/system/clocksource/clocksource0/current_clocksource") + "' as a root", Advice.Severity.L2, "https://access.redhat.com/solutions/18627", "" + headers.sys_data.get((Object)"/sys/devices/system/clocksource/clocksource0/current_clocksource").lineNumber))));
        advices.add((rangeStart, rangeEnd) -> {
            Optional<List<String>> thpSharedMemOptions = Utils.getStringList(headers.sys_data, THP.SHMEM_ENABLED.file);
            boolean isSharedMemTHPSupported = thpSharedMemOptions.isPresent();
            boolean isSharedMemTHPEnabled = Optional.ofNullable(headers.thp_for_java_heap_enabled).orElse(false);
            if (isSharedMemTHPSupported && !isSharedMemTHPEnabled) {
                return Optional.of(new Advice("THP for shared memory is not enabled", "Consider enabling THP for shared memory which can improve performance and CPU usage.\nRecommend settings are:\n\t" + THP.SHMEM_ENABLED.getRecommendationSetting() + "\n\t" + THP.ENABLED.getRecommendationSetting() + "\n\t" + THP.DEFRAG.getRecommendationSetting() + "\n\t" + THP.KHUGEPAGE_DEFRAG.getRecommendationSetting() + "\n", Advice.Severity.L2, "https://docs.azul.com/prime/Enable-Huge-Pages"));
            }
            List hugePageStatRecordsWithStalls = RecordFilters.HUGE_PAGE_COMPACTION_STALLS.getRecordsInVisibleRange(model, (long)rangeStart, (long)rangeEnd);
            if (!hugePageStatRecordsWithStalls.isEmpty()) {
                boolean foundIncorrectTHPSetting;
                String url = null;
                StringBuilder recipeMessageBuilder = new StringBuilder();
                recipeMessageBuilder.append("Observed system-wide pauses caused by Linux memory defragmentation.").append("\n");
                Optional<List<String>> thpAnonMemOptions = Utils.getStringList(headers.sys_data, THP.ENABLED.file);
                Optional<List<String>> thpDefragOptions = Utils.getStringList(headers.sys_data, THP.DEFRAG.file);
                Optional<String> thpKHPDefragOption = Utils.getString(headers.sys_data, THP.KHUGEPAGE_DEFRAG.file);
                boolean isPreferredTHPSharedMemOption = isSharedMemTHPSupported && thpSharedMemOptions.get().contains(THP.SHMEM_ENABLED.expectedSetting);
                boolean isPreferredTHPAnonMemOption = thpAnonMemOptions.filter(value -> value.contains(THP.ENABLED.expectedSetting)).isPresent();
                boolean isPreferredTHPDefragOption = thpDefragOptions.filter(value -> value.contains(THP.DEFRAG.expectedSetting)).isPresent();
                boolean isPreferredTHPKHPDefragOption = thpKHPDefragOption.filter(value -> value.equals(THP.KHUGEPAGE_DEFRAG.expectedSetting)).isPresent();
                boolean isAnonMemTHPEnabled = isPreferredTHPAnonMemOption;
                boolean bl = foundIncorrectTHPSetting = !isPreferredTHPSharedMemOption || !isPreferredTHPDefragOption || !isPreferredTHPKHPDefragOption;
                if (isAnonMemTHPEnabled && foundIncorrectTHPSetting) {
                    recipeMessageBuilder.append("Consider recommended THP settings provided in the link below to reduce system-wide Linux memory defragmentation pauses.");
                    url = "https://docs.azul.com/prime/Enable-Huge-Pages#transparent-huge-pages-thp";
                }
                return Optional.of(new Advice("Stalls due to Memory Compaction observed", recipeMessageBuilder.toString(), Advice.Severity.L2, url, "Memory Compaction"));
            }
            return Optional.empty();
        });
        advices.add((rangeStart, rangeEnd) -> {
            List<Double> vmaCounterRecordsBeyondThreshold = RecordFilters.VMA_GREATER_THAN_50PCT.getValuesInVisibleRange(model, (long)rangeStart, (long)rangeEnd);
            Optional<Integer> vmaMaxValue = Utils.getInt(headers.sys_data, "/proc/sys/vm/max_map_count");
            int vmaCountMax = vmaMaxValue.orElseGet(() -> Utils.getLogRecordsAsStream(model, VmaCountersRecord.class).map(VmaCountersRecord.class::cast).map(vmaCountersRecord -> vmaCountersRecord.vmaMax).findFirst().orElse(0));
            if (!vmaCounterRecordsBeyondThreshold.isEmpty() && vmaCountMax < 1000000 && StatsProvider.getStats(vmaCounterRecordsBeyondThreshold).isShowingUpTrend) {
                return Optional.of(new Advice("VMA use has exceeded 50% of the current max. value (" + vmaCountMax + ") and continues to show upward trend", "Consider increasing the number of virtual memory areas (VMAs) by doing: \n'" + TextToHTML.toItalic("echo \"1000000\" > /proc/sys/vm/max_map_count") + "' as a root", Advice.Severity.L1, "https://docs.azul.com/prime/installation-and-configuration#_ensuring-sufficient-virtual-memory-areas", "VMA Use"));
            }
            return Optional.empty();
        });
        advices.add((rangeStart, rangeEnd) -> {
            List findDeadlocksPauseEvents = Utils.getLogRecordsInGivenRangeAsStream(model, SafepointRecord.class, rangeStart, rangeEnd).filter(safepointRecord -> safepointRecord.op_name_label.equals("Find Deadlocks Pause")).collect(Collectors.toList());
            if (!findDeadlocksPauseEvents.isEmpty()) {
                double avgTimeBetweenEvents = Utils.getAvgEventFrequencyGivenLogRecords(findDeadlocksPauseEvents);
                int numberOfEvents = findDeadlocksPauseEvents.size();
                if (avgTimeBetweenEvents < 10.0) {
                    return Optional.of(new Advice("Multiple (" + numberOfEvents + ") pauses due to 'Find Deadlock' event is detected", "The frequency of such event is : 1 every " + String.format("%.1f", avgTimeBetweenEvents) + " sec, which is too high. \nThe application may be experiencing these due profiling tools (such as JProfiler, AppDynamics etc.) attached to it.\n\nConsider reducing it (to say 1 every 10 sec) by appropriately configuring the profiler \nor explicitly set JVM flag " + TextToHTML.toItalic("-XX:-AllowExplicitFindDeadlocks") + "\n and restart to request JVM to ignore such calls IFF you do not wish to profile the Deadlock events.\n", Advice.Severity.L2, null, "Pause Duration"));
                }
            }
            return Optional.empty();
        });
        advices.add((rangeStart, rangeEnd) -> {
            List getAllStackTracesPauseEvents = Utils.getLogRecordsInGivenRangeAsStream(model, SafepointRecord.class, rangeStart, rangeEnd).filter(safepointRecord -> safepointRecord.op_name_label.equals("Get All Stack Traces Pause")).collect(Collectors.toList());
            if (!getAllStackTracesPauseEvents.isEmpty()) {
                double avgTimeBetweenEvents = Utils.getAvgEventFrequencyGivenLogRecords(getAllStackTracesPauseEvents);
                int numberOfEvents = getAllStackTracesPauseEvents.size();
                if (avgTimeBetweenEvents < 10.0) {
                    return Optional.of(new Advice("Multiple (" + numberOfEvents + ") pauses due to 'Get All Stack Traces' event is detected", "The frequency of such event is : 1 every " + String.format("%.1f", avgTimeBetweenEvents) + " sec, which is too high.\nThe application may be experiencing these due profiling tools (such as JProfiler, AppDynamics etc.) attached to it.\n\nConsider reducing it (to say 1 every 10 sec) by appropriately configuring the profiler\nor explicitly set JVM flag " + TextToHTML.toItalic("-XX:-AllowExplicitThreadDumps") + "\n and restart to request JVM to ignore such calls IFF you do not wish to profile the StackTrace events.\n", Advice.Severity.L2, null, "Pause Duration"));
                }
            }
            return Optional.empty();
        });
        Optional<ProfstatsRecord> profstatsRecord = Utils.getLogRecordsAsStream(model, ProfstatsRecord.class).findFirst();
        if (profstatsRecord.isEmpty()) {
            advices.add((rangeStart, rangeEnd) -> {
                List deoptPauseRecords = RecordFilters.DEOPT_PAUSE_OP_TIME.getRecords(model);
                List deoptPauseRecordsFirst60Seconds = deoptPauseRecords.stream().filter(safepointRecord -> safepointRecord.op_ms > 0.0).filter(safepointRecord -> safepointRecord.getEventRelativeTimestamp(TimeUnit.SECONDS) < 60.0).collect(Collectors.toList());
                if (!deoptPauseRecordsFirst60Seconds.isEmpty()) {
                    int numberOfEvents = deoptPauseRecordsFirst60Seconds.size();
                    return Optional.of(new Advice("Multiple (" + numberOfEvents + ") deopt pauses occurred during the application startup", "Consider using Azul Prime's ReadyNow technology to eliminate such deopt pauses.", Advice.Severity.L2, "https://docs.azul.com/prime/Use-ReadyNow", "Pause Duration"));
                }
                return Optional.empty();
            });
        }
        advices.add((rangeStart, rangeEnd) -> {
            List<GCRecord> gcRecordsWithDelays = RecordFilters.ALLOC_DELAY.getRecordsInVisibleRange(model, gcRecord -> gcRecord.max_thread_delay > 0.0, (long)rangeStart, (long)rangeEnd);
            if (!gcRecordsWithDelays.isEmpty()) {
                gcRecordsWithDelays.sort((o1, o2) -> Double.compare(o2.max_thread_delay, o1.max_thread_delay));
                GCRecord largestThreadDelayRecord = gcRecordsWithDelays.get(0);
                return Optional.of(new Advice("Application faced one or more Allocation Delays/Stalls", String.format("Longest Delay/Stall : %.2f sec @ an uptime of %.2f seconds", largestThreadDelayRecord.max_thread_delay, Utils.getLogRecordTimeStampInSeconds(largestThreadDelayRecord)), Advice.Severity.L2, null, "Application Thread Allocation Delayed"));
            }
            return Optional.empty();
        });
        advices.add((rangeStart, rangeEnd) -> {
            List<SysinfoRecord> highLoadAvgRecords = RecordFilters.LOAD_AVG_1MIN.getRecordsInVisibleRange(model, logRecord -> logRecord.load1 > 1.5 * headers.cg_active_processor_count, (long)rangeStart, (long)rangeEnd);
            if (!highLoadAvgRecords.isEmpty()) {
                highLoadAvgRecords.sort((o1, o2) -> Double.compare(o2.load1, o1.load1));
                SysinfoRecord peakLoadAvgRecord = highLoadAvgRecords.get(0);
                return Optional.of(new Advice("High load average", String.format("Application has operated under 1 minute load average at >1.5x of the available processor limit on %d occasion(s).\nPeak 1min load avg being %.2f @ an uptime of %.2f seconds.", highLoadAvgRecords.size(), peakLoadAvgRecord.load1, Utils.getLogRecordTimeStampInSeconds(peakLoadAvgRecord)), Advice.Severity.L2, null, "Load Average"));
            }
            return Optional.empty();
        });
        advices.add((rangeStart, rangeEnd) -> {
            List highGCTimePercentValues = RecordFilters.GC_TIME_PERCENT.getValuesInVisibleRange(model, (long)rangeStart, (long)rangeEnd).stream().filter(y -> y > 80.0).collect(Collectors.toList());
            if (!highGCTimePercentValues.isEmpty()) {
                return Optional.of(new Advice("High GC Time", String.format("GC Time Percent above 80 percent seen on %d occasion(s).\n", highGCTimePercentValues.size()), Advice.Severity.L2, null, "GC Time (Percent)"));
            }
            return Optional.empty();
        });
        advices.add((rangeStart, rangeEnd) -> {
            double swapOutPagesMax;
            List swapPageInRecords = RecordFilters.SWAP_PAGE_IN_GT_0.getRecordsInVisibleRange(model, (long)rangeStart, (long)rangeEnd);
            double swapInPagesMax = !swapPageInRecords.isEmpty() ? (double)((Long)Collections.max(swapPageInRecords.stream().map(x -> x.delta_swapPageIn).collect(Collectors.toList()))).longValue() : 0.0;
            List swapPageOutRecords = RecordFilters.SWAP_PAGE_OUT_GT_0.getRecordsInVisibleRange(model, (long)rangeStart, (long)rangeEnd);
            double d = swapOutPagesMax = !swapPageOutRecords.isEmpty() ? (double)((Long)Collections.max(swapPageOutRecords.stream().map(x -> x.delta_swapPageOut).collect(Collectors.toList()))).longValue() : 0.0;
            if (swapInPagesMax > 0.0 || swapOutPagesMax > 0.0) {
                return Optional.of(new Advice("Non-zero Swap Usage", "Any non-zero Swap usage may introduce application latency.\n" + String.format("Number of pages Swapped In  since application start : %.0f\n", swapInPagesMax) + String.format("Number of pages Swapped Out since application start : %.0f", swapOutPagesMax), Advice.Severity.L2, null, "Swapping Behavior"));
            }
            return Optional.empty();
        });
        advices.add((rangeStart, rangeEnd) -> {
            List<Double> nonZeroCGThrottledTimeValues = RecordFilters.CG_THROTTLED_TIME.getValuesInVisibleRange(model, logRecord -> logRecord.cg_cpu_throttle_throttled_ms > 0L, (long)rangeStart, (long)rangeEnd);
            if (!nonZeroCGThrottledTimeValues.isEmpty()) {
                return Optional.of(new Advice("CGroup CPU throttling time is non-zero", "Application latency may have been affected due to CGroup CPU throttling.\n" + String.format("Total time duration for which entities of the group have been throttled: %.2f ms.", Collections.max(nonZeroCGThrottledTimeValues)), Advice.Severity.L2, null, "CPU Throttled Time"));
            }
            return Optional.empty();
        });
        return advices;
    }

    private static enum THP {
        SHMEM_ENABLED("/sys/kernel/mm/transparent_hugepage/shmem_enabled", "[advise]"),
        ENABLED("/sys/kernel/mm/transparent_hugepage/enabled", "[madvise]"),
        DEFRAG("/sys/kernel/mm/transparent_hugepage/defrag", "[defer]"),
        KHUGEPAGE_DEFRAG("/sys/kernel/mm/transparent_hugepage/khugepaged/defrag", "1");

        final String file;
        final String expectedSetting;

        private THP(String file, String expectedSetting) {
            this.file = file;
            this.expectedSetting = expectedSetting;
        }

        public String getRecommendationMessage() {
            return "Recommended setting for " + TextToHTML.toItalic(this.file) + " is " + this.expectedSetting.replaceAll("[^a-zA-Z0-9]", "");
        }

        public String getRecommendationSetting() {
            return TextToHTML.toItalic(this.file + "=" + this.expectedSetting);
        }
    }
}

