/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.advisor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class VMFlagsDependencyInfo {
    private final List<String> vmFlagsOnCmdLine;
    private final Set<String> vmFlagsOnCmdLineSet;

    private VMFlagsDependencyInfo(List<String> vmFlagsOnCmdLine) {
        this.vmFlagsOnCmdLine = Collections.unmodifiableList(vmFlagsOnCmdLine);
        this.vmFlagsOnCmdLineSet = new HashSet<String>(vmFlagsOnCmdLine);
    }

    public static VMFlagsDependencyInfo create(String vmFlagsOnCommandLine) {
        List<String> jvmArgumentsList = vmFlagsOnCommandLine == null || vmFlagsOnCommandLine.trim().isEmpty() ? Collections.emptyList() : VMFlagsDependencyInfo.fetchVMArgumentsAsList(vmFlagsOnCommandLine);
        return new VMFlagsDependencyInfo(jvmArgumentsList);
    }

    private static List<String> fetchVMArgumentsAsList(String vmFlags) {
        return Arrays.stream((" " + vmFlags.trim()).split(" +-(?!\\d)")).map(flag -> "-" + flag).map(flag -> flag.replaceAll("=.*", "=")).filter(flag -> flag.startsWith("-X")).collect(Collectors.toList());
    }

    public List<String> getVMFlagsOnCmdLineAsList() {
        return this.vmFlagsOnCmdLine;
    }

    public List<String> getMissingDependentsFor(String inputVMFlag) {
        List<String> anyMatchingDependents = VMFlagKnowledgeBase.getAnyMatchingDependentsOf(inputVMFlag);
        if (!anyMatchingDependents.isEmpty() && anyMatchingDependents.stream().noneMatch(this::isInputVMFlagOrItsAliasPresentOnCommandLine)) {
            return DecorateListToString.orSeparated(anyMatchingDependents);
        }
        return VMFlagKnowledgeBase.getDependentsOf(inputVMFlag).stream().filter(Predicate.not(this::isInputVMFlagOrItsAliasPresentOnCommandLine)).collect(Collectors.toUnmodifiableList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInputVMFlagOrItsAliasPresentOnCommandLine(String inputVMFlag) {
        if (this.vmFlagsOnCmdLineSet.contains(inputVMFlag)) return true;
        if (!VMFlagKnowledgeBase.getAliasOf(inputVMFlag).stream().anyMatch(this.vmFlagsOnCmdLineSet::contains)) return false;
        return true;
    }

    private static final class DecorateListToString {
        private DecorateListToString() {
        }

        public static List<String> orSeparated(List<String> anyMatchingDependents) {
            return new ArrayList<String>(anyMatchingDependents){

                @Override
                public String toString() {
                    return "[" + String.join((CharSequence)" or ", this) + "]";
                }
            };
        }
    }

    static final class VMFlagKnowledgeBase {
        private static final Map<String, List<String>> VM_FLAG_DEPENDENTS = Map.of("-XX:CompilerTier2BudgetingCPUPercent=", List.of("-XX:+EnableTier2CompilerBudgeting"), "-XX:CompilerTier2BudgetingWarmupCPUPercent=", List.of("-XX:+EnableTier2CompilerBudgeting"), "-XX:CompilerTier2BudgetWindowDurationMs=", List.of("-XX:+EnableTier2CompilerBudgeting"));
        private static final Map<String, List<String>> VM_FLAG_DEPENDENCY_ANY = Map.of("-XX:CompilerWarmupPeriodSeconds=", List.of("-XX:CompilerWarmupExtraThreads=", "-XX:CompilerTier2BudgetingWarmupCPUPercent="));
        private static final Map<String, List<String>> VM_FLAG_ALIAS = Map.of();

        private VMFlagKnowledgeBase() {
        }

        public static List<String> getAliasOf(String inputVMFlag) {
            return Collections.unmodifiableList(VM_FLAG_ALIAS.getOrDefault(inputVMFlag, Collections.emptyList()));
        }

        public static List<String> getDependentsOf(String inputVMFlag) {
            return Collections.unmodifiableList(VM_FLAG_DEPENDENTS.getOrDefault(inputVMFlag, Collections.emptyList()));
        }

        public static List<String> getAnyMatchingDependentsOf(String inputVMFlag) {
            return Collections.unmodifiableList(VM_FLAG_DEPENDENCY_ANY.getOrDefault(inputVMFlag, Collections.emptyList()));
        }
    }
}

