/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.model.spi.LogRecordLabelConverter;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_DoubleHeaderDataParser;
import com.azul.log.parser.impl.c4.C4_FieldTypes;
import com.azul.log.parser.impl.c4.C4_ParserState;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.records.C4_LogHeader;
import com.azul.log.parser.impl.c4.records.SysinfoRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import com.azul.log.parser.support.SlidingWindowAggregator;
import com.azul.log.parser.utils.TextUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.openide.util.Lookup;

@C4_LogDataRecord(header_marker="GCH", data_marker="GC")
@C4_FieldsDescription(file="c4/GCRecord")
public final class GCRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="type")
    public String type;
    @C4_GCLogRecordField(header="label")
    public String label;
    @C4_GCLogRecordField(header="tot_ct-cyc_ct")
    public String cycle_id;
    @C4_GCLogRecordField(header="heap usage MB#max", defaultUnits=LogUnits.MEGABYTES)
    public int heap_committed_non_pause_mb;
    @C4_GCLogRecordField(header="heap usage MB#peak", defaultUnits=LogUnits.MEGABYTES)
    public int peak_non_pause_mb_used;
    @C4_GCLogRecordField(header="heap usage MB#cur", defaultUnits=LogUnits.MEGABYTES)
    public int committed_mb_used;
    @C4_GCLogRecordField(header="heap usage MB#pcommit", defaultUnits=LogUnits.MEGABYTES)
    public int peak_committed_mb;
    @C4_GCLogRecordField(header="heap usage MB#ppause", defaultUnits=LogUnits.MEGABYTES)
    public int peak_pause_mb_used;
    @C4_GCLogRecordField(header="heap usage MB#upause", defaultUnits=LogUnits.MEGABYTES)
    public int unreturned_pause_mb;
    @C4_GCLogRecordField(header="heap usage MB#rss", defaultUnits=LogUnits.MEGABYTES)
    public int off_heap_committed_mb;
    @C4_GCLogRecordField(header="heap usage MB#codec_cap", defaultUnits=LogUnits.MEGABYTES)
    public int code_cache_cap_mb;
    @C4_GCLogRecordField(header="heap usage MB#codec", defaultUnits=LogUnits.MEGABYTES)
    public int code_cache_used_mb;
    @C4_GCLogRecordField(header="heap usage MB#monitors", defaultUnits=LogUnits.MEGABYTES)
    public int monitor_cache_used_mb;
    @C4_GCLogRecordField(header="heap usage MB#jsys", defaultUnits=LogUnits.MEGABYTES)
    public int java_system_memory_use_mb;
    @C4_GCLogRecordField(header="heap usage MB#zsys", defaultUnits=LogUnits.MEGABYTES)
    public int zing_system_memory_use_mb;
    @C4_GCLogRecordField(header="gens MB#new", defaultUnits=LogUnits.MEGABYTES)
    public int new_gen_used;
    @C4_GCLogRecordField(header="gens MB#old", defaultUnits=LogUnits.MEGABYTES)
    public int old_gen_used;
    @C4_GCLogRecordField(header="gens MB#perm", defaultUnits=LogUnits.MEGABYTES)
    public int perm_gen_used;
    @C4_GCLogRecordField(header="gens MB#internal", defaultUnits=LogUnits.MEGABYTES)
    public int internal_used;
    @C4_GCLogRecordField(header="gens MB#gen-peak", defaultUnits=LogUnits.MEGABYTES)
    public int gen_peak;
    @C4_GCLogRecordField(header="heap info MB#live", defaultUnits=LogUnits.MEGABYTES)
    public int gen_live;
    @C4_GCLogRecordField(header="heap info MB#frag", defaultUnits=LogUnits.MEGABYTES)
    public int gen_frag;
    @C4_GCLogRecordField(header="heap info MB#found", defaultUnits=LogUnits.MEGABYTES)
    public int garbage_mb_found;
    @C4_GCLogRecordField(header="heap info MB#cllctd", defaultUnits=LogUnits.MEGABYTES)
    public int garbage_collected;
    @C4_GCLogRecordField(header="heap info MB#lmtd", defaultUnits=LogUnits.MEGABYTES)
    public int sideband_limited;
    @C4_GCLogRecordField(header="pages#prom", defaultUnits=LogUnits.PAGES)
    public int promoted_to_old;
    @C4_GCLogRecordField(header="pages#reloc", defaultUnits=LogUnits.PAGES)
    public int relocated;
    @C4_GCLogRecordField(header="pages#noreloc", defaultUnits=LogUnits.PAGES)
    public int norelocate;
    @C4_GCLogRecordField(header="pages#rspike", defaultUnits=LogUnits.PAGES)
    public int reloc_spike;
    @C4_GCLogRecordField(header="pages#sm", defaultUnits=LogUnits.PAGES)
    public int small_space_count;
    @C4_GCLogRecordField(header="pages#md", defaultUnits=LogUnits.PAGES)
    public int mid_space_count;
    @C4_GCLogRecordField(header="pages#lg", defaultUnits=LogUnits.PAGES)
    public int large_space_count;
    @C4_GCLogRecordField(header="intercycle#sec", defaultUnits=LogUnits.SECONDS)
    public double inter_seconds;
    @C4_GCLogRecordField(header="intercycle#alloc-rate", defaultUnits=LogUnits.RATE_MBPS)
    public double inter_gen_alloc_rate;
    @C4_GCLogRecordField(header="intercycle#perm-rate", defaultUnits=LogUnits.RATE_MBPS)
    public double inter_perm_alloc_rate;
    @C4_GCLogRecordField(header="intracycle#sec", defaultUnits=LogUnits.SECONDS)
    public double intra_seconds;
    @C4_GCLogRecordField(header="intracycle#alloc-rate", defaultUnits=LogUnits.RATE_MBPS)
    public double intra_gen_alloc_rate;
    @C4_GCLogRecordField(header="intracycle#perm-rate", defaultUnits=LogUnits.RATE_MBPS)
    public double intra_perm_alloc_rate;
    @C4_GCLogRecordField(header="gc#thrds", defaultUnits=LogUnits.THREADS)
    public int thread_count;
    @C4_GCLogRecordField(header="gc#md")
    public String mode;
    @C4_GCLogRecordField(header="gc#diag")
    public String diag;
    @C4_GCLogRecordField(header="threads#tot", defaultUnits=LogUnits.THREADS)
    public int threads;
    @C4_GCLogRecordField(header="threads#delayed", defaultUnits=LogUnits.THREADS, alias="delay_count")
    public int delay_count_oldfmt;
    @C4_GCLogRecordField(header="delay#cnt", defaultUnits=LogUnits.THREADS)
    public int delay_count;
    @C4_GCLogRecordField(header="delay#avg", defaultUnits=LogUnits.SECONDS)
    public double avg_thread_delay;
    @C4_GCLogRecordField(header="delay#max", defaultUnits=LogUnits.SECONDS)
    public double max_thread_delay;
    @C4_GCLogRecordField(header="failed#cnt", defaultUnits=LogUnits.THREADS)
    public int failed_delays;
    @C4_GCLogRecordField(header="failed#avg", defaultUnits=LogUnits.SECONDS)
    public double failed_avg_thread_delay;
    @C4_GCLogRecordField(header="failed#max", defaultUnits=LogUnits.SECONDS)
    public double failed_max_thread_delay;
    @C4_GCLogRecordField(header="paced#cnt", defaultUnits=LogUnits.THREADS)
    public int paced_delays;
    @C4_GCLogRecordField(header="paced#avg", defaultUnits=LogUnits.SECONDS)
    public double paced_avg_thread_delay;
    @C4_GCLogRecordField(header="paced#max", defaultUnits=LogUnits.SECONDS)
    public double paced_max_thread_delay;
    @C4_GCLogRecordField(header="gc#start", defaultUnits=LogUnits.SECONDS)
    public double start;
    @C4_GCLogRecordField(header="pause 1#start", defaultUnits=LogUnits.SECONDS)
    public double pause1_start;
    @C4_GCLogRecordField(header="pause 1#dur", defaultUnits=LogUnits.SECONDS)
    public double pause1_duration;
    @C4_GCLogRecordField(header="pause 2#start", defaultUnits=LogUnits.SECONDS)
    public double pause2_start;
    @C4_GCLogRecordField(header="pause 2#dur", defaultUnits=LogUnits.SECONDS)
    public double pause2_duration;
    @C4_GCLogRecordField(header="pause 3#start", defaultUnits=LogUnits.SECONDS)
    public double pause3_start;
    @C4_GCLogRecordField(header="pause 3#dur", defaultUnits=LogUnits.SECONDS)
    public double pause3_duration;
    @C4_GCLogRecordField(header="pause 4#start", defaultUnits=LogUnits.SECONDS)
    public double pause4_start;
    @C4_GCLogRecordField(header="pause 4#dur", defaultUnits=LogUnits.SECONDS)
    public double pause4_duration;
    @C4_GCLogRecordField(header="cpu usage ms#mark", defaultUnits=LogUnits.MILLISECONDS)
    public double cpu_usage_ms_mark;
    @C4_GCLogRecordField(header="cpu usage ms#reloc", defaultUnits=LogUnits.MILLISECONDS)
    public double cpu_usage_ms_reloc;
    @C4_GCLogRecordField(header="cpu usage ms#fixup", defaultUnits=LogUnits.MILLISECONDS)
    public double cpu_usage_ms_fixup;
    @C4_GCLogRecordField(header="total classes#loaded", defaultUnits=LogUnits.COUNT)
    public double total_loaded_classes;
    @C4_GCLogRecordField(header="total classes#unloaded", defaultUnits=LogUnits.COUNT)
    public double total_unloaded_classes;
    @C4_GCLogRecordField(header="end#end", defaultUnits=LogUnits.SECONDS)
    public double end_old_logs = -1.0;
    @C4_GCLogRecordField(header="end#end(s)", defaultUnits=LogUnits.SECONDS)
    public double end = -1.0;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public int code_cache_size_limit_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public int monitor_cache_size_limit_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"peak", "heap_committed_non_pause_mb"})
    public int peak_contingency_use_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"used_after_gc_mb", "heap_committed_non_pause_mb"})
    public int after_gc_contingency_use_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.SECONDS, deps={"pause1_start", "start"})
    public double premark_time;
    @LogRecordCalculatedField(defaultUnits=LogUnits.SECONDS, deps={"pause2_start", "pause1_start", "pause1_duration"})
    public double mark_time;
    @LogRecordCalculatedField(defaultUnits=LogUnits.SECONDS, deps={"pause3_start", "pause2_start", "pause2_duration"})
    public double ref_proc_time;
    @LogRecordCalculatedField(defaultUnits=LogUnits.SECONDS, deps={"pause4_start", "pause3_start", "pause3_duration"})
    public double mcar_setup_time;
    @LogRecordCalculatedField(defaultUnits=LogUnits.SECONDS, deps={"start", "intra_seconds", "pause4_start", "pause4_duration"})
    public double reloc_time;
    @LogRecordCalculatedField(defaultUnits=LogUnits.GCCYCLES, deps={"cycle_id"})
    public int gc_count;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PERCENT, deps={"inter_seconds", "intra_seconds", "intra_seconds"})
    public double percent_time_in_gc;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"peak_non_pause_mb_used"})
    public int peak;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"committed_mb_used"})
    public int used_after_gc_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"heap_committed_non_pause_mb"})
    public int heap_committed_total_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"heap_committed_total_mb", "off_heap_committed_mb"})
    public int total_process_memory_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"gen_live", "norelocate"})
    public int gen_known_live;
    @LogRecordCalculatedField(deps={"label"})
    public int reason_code;
    @LogRecordCalculatedField
    public static C4_FieldTypes.CacheLocation code_cache_location;
    @LogRecordCalculatedField
    public static C4_FieldTypes.CacheLocation monitor_cache_location;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public static int java_system_max;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public static int code_cache_initial_size_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public static Integer monitor_cache_initial_size_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public static int new_gen_virtual_use_limit_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public static int old_and_perm_gen_virtual_use_limit_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public static int new_gen_physical_use_soft_limit_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public static int old_and_perm_gen_physical_use_soft_limit_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES)
    public static int java_heap_Xmx_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"off_heap_committed_mb"})
    public long native_heap_estimate_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PERCENT, deps={"cpu_usage_ms_mark", "cpu_usage_ms_reloc", "cpu_usage_ms_fixup", "inter_seconds", "intra_seconds"})
    public double cpu_usage_percent_of_limit;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PERCENT, deps={"cpu_usage_ms_mark", "cpu_usage_ms_reloc", "cpu_usage_ms_fixup", "inter_seconds", "intra_seconds"})
    public double cpu_usage_percent_of_limit_30;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PERCENT, deps={"cpu_usage_ms_mark", "cpu_usage_ms_reloc", "cpu_usage_ms_fixup", "inter_seconds", "intra_seconds"})
    public double cpu_usage_percent_of_limit_60;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PERCENT, deps={"cpu_usage_ms_mark", "cpu_usage_ms_reloc", "cpu_usage_ms_fixup", "inter_seconds", "intra_seconds"})
    public double cpu_usage_percent_of_request;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PERCENT, deps={"cpu_usage_ms_mark", "cpu_usage_ms_reloc", "cpu_usage_ms_fixup", "inter_seconds", "intra_seconds"})
    public double cpu_usage_percent_of_request_30;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PERCENT, deps={"cpu_usage_ms_mark", "cpu_usage_ms_reloc", "cpu_usage_ms_fixup", "inter_seconds", "intra_seconds"})
    public double cpu_usage_percent_of_request_60;
    private RelativeTimestamp endTimestamp = null;
    private static final AtomicBoolean static_fields_initialized;
    private static final Field code_cache_cap_field;
    private static final Map<String, List<CpuUsage>> cpuUsageStatsMap;
    private static boolean isCPUSharesDefined;

    @Override
    public Double getDoubleValue(Field fld, LogUnits targetUnits) {
        Double value = super.getDoubleValue(fld, targetUnits);
        if (value == null && fld.equals(code_cache_cap_field)) {
            value = LogUnits.MEGABYTES.convertTo(this.code_cache_size_limit_mb, targetUnits);
        }
        return value;
    }

    public String getGCType() {
        return this.isOld() ? GCType.OLD.toString() : GCType.NEW.toString();
    }

    public boolean isNew() {
        return !this.isOld();
    }

    public boolean isNto() {
        return "NTO".equals(this.type);
    }

    public boolean isOld() {
        return "Old".equals(this.type);
    }

    private boolean isPureFullGC() {
        return this.diag.length() > 3 && this.diag.charAt(3) == '1';
    }

    public boolean isNewPureFullGC() {
        return this.isNew() && this.isPureFullGC();
    }

    public boolean isNewNotPureFullGC() {
        return this.isNew() && !this.isPureFullGC();
    }

    @Override
    public LogRecord.PhaseInfoList getEventPhasesImpl() {
        LogRecord.PhaseInfoList result = new LogRecord.PhaseInfoList(this.type + " [" + this.label + "] GC Cycle #" + this.gc_count, TimeUnit.SECONDS);
        RelativeTimestamp cycle_start = RelativeTimestamp.of(this.start, TimeUnit.SECONDS);
        RelativeTimestamp p1_start = null;
        RelativeTimestamp p1_end = null;
        RelativeTimestamp p2_start = null;
        RelativeTimestamp p2_end = null;
        RelativeTimestamp p3_start = null;
        RelativeTimestamp p3_end = null;
        RelativeTimestamp p4_start = null;
        RelativeTimestamp p4_end = null;
        if (this.pause1_start > 0.0) {
            p1_start = RelativeTimestamp.of(this.pause1_start, TimeUnit.SECONDS);
            p1_end = p1_start.shift(this.pause1_duration, TimeUnit.SECONDS);
        }
        if (this.pause2_start > 0.0) {
            p2_start = RelativeTimestamp.of(this.pause2_start, TimeUnit.SECONDS);
            p2_end = p2_start.shift(this.pause2_duration, TimeUnit.SECONDS);
        }
        if (this.pause3_start > 0.0) {
            p3_start = RelativeTimestamp.of(this.pause3_start, TimeUnit.SECONDS);
            p3_end = p3_start.shift(this.pause3_duration, TimeUnit.SECONDS);
        }
        if (this.pause4_start > 0.0) {
            p4_start = RelativeTimestamp.of(this.pause4_start, TimeUnit.SECONDS);
            p4_end = p4_start.shift(this.pause4_duration, TimeUnit.SECONDS);
        }
        if (p1_start != null) {
            result.add(new LogRecord.PhaseInfo(cycle_start, p1_start, "Pre-Mark"));
        }
        if (p1_start != null) {
            result.add(new LogRecord.PhaseInfo(p1_start, p1_end, "Pause 1"));
        }
        if (p1_end != null && p2_start != null) {
            result.add(new LogRecord.PhaseInfo(p1_end, p2_start, "Marking"));
        }
        if (p2_start != null) {
            result.add(new LogRecord.PhaseInfo(p2_start, p2_end, "Pause 2"));
        }
        if (p2_end != null && p3_start != null) {
            result.add(new LogRecord.PhaseInfo(p2_end, p3_start, "Refs Processing"));
        }
        if (p3_start != null) {
            result.add(new LogRecord.PhaseInfo(p3_start, p3_end, "Pause 3"));
        }
        if (p3_end != null && p4_start != null) {
            result.add(new LogRecord.PhaseInfo(p3_end, p4_start, "Mark Cleanup And Relocation Setup"));
        }
        if (p4_start != null) {
            result.add(new LogRecord.PhaseInfo(p4_start, p4_end, "Pause 4"));
        }
        if (p4_end != null) {
            result.add(new LogRecord.PhaseInfo(p4_end, this.endTimestamp, "Relocation and Fixup"));
        }
        return result;
    }

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return this.endTimestamp;
    }

    public static boolean isCPUSharesDefined() {
        return isCPUSharesDefined;
    }

    static {
        static_fields_initialized = new AtomicBoolean(false);
        code_cache_cap_field = GCRecord.getField(GCRecord.class, "code_cache_cap_mb");
        cpuUsageStatsMap = new HashMap<String, List<CpuUsage>>();
    }

    public static enum ReasonCodes {
        Unknown("Unknown"),
        Max("Heuristic Trigger"),
        Alo("Allocation Failure"),
        Res("System Res Limit"),
        Mem("System Java Limit"),
        Sys("System.gc()"),
        TI("JVMTI Force GC"),
        HI("Heap Inspection"),
        TIIOH("JVMTI Heap Iter"),
        TIIOR("JVMTI Obj Iter"),
        RNI("RNImage Force GC"),
        HD("Heap Dump");

        private static final ReasonCodes[] codes;
        private static final String[] labels;
        private final String descr;

        private ReasonCodes(String descr) {
            this.descr = descr;
        }

        public String getDescr() {
            return this.descr;
        }

        public static ReasonCodes fromID(int id) {
            return id >= 0 && id < codes.length ? codes[id] : Unknown;
        }

        public int toID() {
            return this.ordinal();
        }

        static {
            codes = ReasonCodes.values();
            labels = Arrays.stream(codes).map(c -> c.descr).collect(Collectors.toList()).toArray(new String[0]);
        }

        public static class GCInfoLabelConverter
        implements LogRecordLabelConverter {
            @Override
            public String convert(double value) {
                return ReasonCodes.fromID((int)value).getDescr();
            }

            @Override
            public String[] getLabels() {
                return labels;
            }
        }
    }

    public static enum GCType {
        NEW("NEW"),
        OLD("OLD");

        private final String type;

        private GCType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    private static class CpuUsage
    extends SlidingWindowAggregator<GCRecord> {
        final double baselineValue;
        final double upperLimit;
        final double windowDurationInMicros;
        private double lastComputedValue;

        public CpuUsage(long windowDurationInSec, BiConsumer<GCRecord, Double> recordUpdater, double baselineValue, double upperLimit) {
            super(windowDurationInSec, recordUpdater);
            this.windowDurationInMicros = TimeUnit.SECONDS.toMicros(windowDurationInSec);
            this.baselineValue = baselineValue;
            this.upperLimit = upperLimit;
        }

        @Override
        public double getComputedValue(GCRecord firstRecord, GCRecord secondRecord) {
            double total_cpu_usage_ms = 0.0;
            double total_duration_ms = 0.0;
            for (GCRecord gcRecord : this.recordsInWindow) {
                total_cpu_usage_ms += gcRecord.cpu_usage_ms_mark + gcRecord.cpu_usage_ms_reloc + gcRecord.cpu_usage_ms_fixup;
                total_duration_ms += (gcRecord.inter_seconds + gcRecord.intra_seconds) * 1000.0;
            }
            return Math.min(this.upperLimit, 100.0 * (total_cpu_usage_ms / total_duration_ms / this.baselineValue));
        }
    }

    public static final class Parser
    extends C4_DoubleHeaderDataParser<GCRecord> {
        private static final String[] firstLineFixupMatrix = new String[]{"                         : heap usage MB                                                : gens MB               : heap info MB                : pages                              : intercycle               intracycle               : gc            : threads     delay   : gc    pause 1   pause 2   pause 3   pause 4   : end", "type label tot_ct-cyc_ct : max peak cur ppause upause rss codec_cap codec monitors jsys : new old perm internal gen-peak : live frag found cllctd lmtd : prom reloc noreloc rspike sm md lg : sec alloc-rate perm-rate sec alloc-rate perm-rate : thrds md diag : tot delayed avg max : start start dur start dur start dur start dur : end", "                         : heap usage MB                                                : gens MB                        : heap info MB                : pages                              : intercycle               intracycle               : gc            : threads     delay   : gc    pause 1   pause 2   pause 3   pause 4   : end", "                         :               heap usage MB               :        gens MB        :        heap info MB         :              pages                 :        intercycle               intracycle        :      gc       :    threads  delay   :  gc    pause 1   pause 2   pause 3   pause 4  : end", "type label tot_ct-cyc_ct : max peak cur ppause upause rss codec jsys : new old perm internal : live frag found cllctd lmtd : prom reloc noreloc rspike sm md lg : sec alloc-rate perm-rate sec alloc-rate perm-rate : thrds md diag : tot delayed avg max : start start dur start dur start dur start dur : end", "                         : heap usage MB                             : gens MB               : heap info MB                : pages                              : intercycle               intracycle               : gc            : threads     delay   : gc    pause 1   pause 2   pause 3   pause 4   : end", "                         :            heap usage MB                  :        gens MB        :        heap info MB         :              pages                 :        intercycle               intracycle        :      gc       :    threads  delay   :  gc    pause 1   pause 2   pause 3   pause 4  : end", "type label tot_ct-cyc_ct : max peak cur ppause upause rss codec zsys : new old perm internal : live frag found cllctd lmtd : prom reloc noreloc rspike sm md lg : sec alloc-rate perm-rate sec alloc-rate perm-rate : thrds md diag : tot delayed avg max : start start dur start dur start dur start dur : end", "                         : heap usage MB                             : gens MB               : heap info MB                : pages                              : intercycle               intracycle               : gc            : threads     delay   : gc    pause 1   pause 2   pause 3   pause 4   : end", "                         :               heap usage MB               :        gens MB        :        heap info MB         :              pages                 :        intercycle               intracycle        :      gc       :    threads  delay   :  gc    pause 1   pause 2   pause 3   pause 4  : end", "type label tot_ct-cyc_ct : max peak cur ppause upause rss codec zsys : new old perm internal : live frag found cllctd lmtd : prom reloc noreloc rspike sm md lg : sec alloc-rate perm-rate sec alloc-rate perm-rate : thrds md diag : tot delayed avg max : start start dur start dur start dur start dur : end", "                         : heap usage MB                             : gens MB               : heap info MB                : pages                              : intercycle               intracycle               : gc            : threads     delay   : gc    pause 1   pause 2   pause 3   pause 4   : end"};
        private C4_LogHeader header;
        private C4_ParserState state;

        public Parser() {
            super(GCRecord.class);
        }

        @Override
        protected String[] getFirstLineFixupMatrix() {
            return firstLineFixupMatrix;
        }

        @Override
        protected Map<String, String> getKnownHeaderSections() {
            return Map.of(" intercycle               intracycle               ", " sec alloc-rate perm-rate sec alloc-rate perm-rate ", " threads  delay       failed      ", " tot      cnt avg max cnt avg max ", " threads  delay       failed      paced       ", " tot      cnt avg max cnt avg max cnt avg max ", " gc    pause 1   pause 2   pause 3   pause 4   ", " start start dur start dur start dur start dur ");
        }

        @Override
        protected void computeCalculatedFields(GCRecord record) throws ParserException {
            double ratio;
            CharSequence gc_count = record.cycle_id.subSequence(record.cycle_id.indexOf(45) + 1, record.cycle_id.length());
            Integer val = TextUtils.parseInt(gc_count);
            if (val == null) {
                throw new ParserException("Unable to parse gc cycle id ->" + gc_count + "<-");
            }
            record.gc_count = val;
            if (record.start == 0.0) {
                record.start = record.pause1_start;
            }
            if (record.pause1_start > 0.0) {
                record.premark_time = record.pause1_start - record.start;
            }
            if (record.pause1_start > 0.0 && record.pause2_start > 0.0) {
                record.mark_time = record.pause2_start - (record.pause1_start + record.pause1_duration);
            }
            if (record.pause2_start > 0.0 && record.pause3_start > 0.0) {
                record.ref_proc_time = record.pause3_start - (record.pause2_start + record.pause2_duration);
            }
            if (record.pause3_start > 0.0 && record.pause4_start > 0.0) {
                record.mcar_setup_time = record.pause4_start - (record.pause3_start + record.pause3_duration);
            }
            if (record.pause4_start > 0.0) {
                record.reloc_time = record.start + record.intra_seconds - (record.pause4_start + record.pause4_duration);
                record.reloc_time = Math.max(0.0, record.reloc_time);
            }
            double d = record.percent_time_in_gc = Math.abs(ratio = record.intra_seconds / (record.inter_seconds + record.intra_seconds)) <= Double.MAX_VALUE ? ratio * 100.0 : 0.0;
            if (static_fields_initialized.compareAndSet(false, true)) {
                if (this.header.java_heap_Xmx_mb == null) {
                    this.header.java_heap_Xmx_mb = record.heap_committed_non_pause_mb;
                }
                int xmx = this.header.java_heap_Xmx_mb;
                java_heap_Xmx_mb = this.header.java_heap_Xmx_mb;
                new_gen_virtual_use_limit_mb = this.header.new_gen_virtual_use_limit;
                old_and_perm_gen_virtual_use_limit_mb = this.header.old_and_perm_gen_virtual_use_limit;
                new_gen_physical_use_soft_limit_mb = this.header.new_gen_physical_use_soft_limit > 0 ? this.header.new_gen_physical_use_soft_limit : xmx;
                old_and_perm_gen_physical_use_soft_limit_mb = this.header.old_and_perm_gen_physical_use_soft_limit > 0 ? this.header.old_and_perm_gen_physical_use_soft_limit : xmx;
                code_cache_location = this.header.code_cache_location;
                if (this.header.code_cache_initial_size_mb != null) {
                    code_cache_initial_size_mb = this.header.code_cache_initial_size_mb;
                }
                monitor_cache_location = this.header.monitor_cache_location;
                if (this.header.monitor_cache_initial_size_mb != null) {
                    monitor_cache_initial_size_mb = this.header.monitor_cache_initial_size_mb;
                }
                java_system_max = this.header.javaSystemMax_mb;
                if (this.header.use_zmm == null && java_system_max > 0) {
                    this.header.use_zmm = true;
                }
                boolean bl = isCPUSharesDefined = this.header.cg_cpu_shares > 0;
            }
            if (cpuUsageStatsMap.size() != 2) {
                cpuUsageStatsMap.computeIfAbsent(record.getGCType(), tier -> new ArrayList());
                if (this.header.active_processor_count > 0.0) {
                    double standardUpperLimit = 100.0;
                    double cgActiveProcessorCount = this.header.active_processor_count;
                    cpuUsageStatsMap.get(record.getGCType()).addAll(List.of(new CpuUsage(0L, (r, u) -> {
                        r.cpu_usage_percent_of_limit = u;
                    }, cgActiveProcessorCount, 100.0), new CpuUsage(30L, (r, u) -> {
                        r.cpu_usage_percent_of_limit_30 = u;
                    }, cgActiveProcessorCount, 100.0), new CpuUsage(60L, (r, u) -> {
                        r.cpu_usage_percent_of_limit_60 = u;
                    }, cgActiveProcessorCount, 100.0)));
                    if (isCPUSharesDefined) {
                        double cpuCountRelativeToCGShares = (double)this.header.cg_cpu_shares / 1024.0;
                        double upperLimit = cgActiveProcessorCount / cpuCountRelativeToCGShares * 100.0;
                        cpuUsageStatsMap.get(record.getGCType()).addAll(List.of(new CpuUsage(0L, (r, u) -> {
                            r.cpu_usage_percent_of_request = u;
                        }, cpuCountRelativeToCGShares, upperLimit), new CpuUsage(30L, (r, u) -> {
                            r.cpu_usage_percent_of_request_30 = u;
                        }, cpuCountRelativeToCGShares, upperLimit), new CpuUsage(60L, (r, u) -> {
                            r.cpu_usage_percent_of_request_60 = u;
                        }, cpuCountRelativeToCGShares, upperLimit)));
                    }
                }
            }
            record.peak = record.peak_non_pause_mb_used + java_system_max;
            record.used_after_gc_mb = record.committed_mb_used + java_system_max;
            record.heap_committed_total_mb = record.heap_committed_non_pause_mb + record.unreturned_pause_mb;
            record.total_process_memory_mb = record.heap_committed_total_mb + record.off_heap_committed_mb;
            if (this.header.code_cache_size_limit_mb != null) {
                record.code_cache_size_limit_mb = this.header.code_cache_size_limit_mb;
            }
            if (this.header.monitor_cache_size_limit_mb != null) {
                record.monitor_cache_size_limit_mb = this.header.monitor_cache_size_limit_mb;
            }
            record.gen_known_live = Math.max(0, record.gen_live - record.norelocate * 2);
            if (Boolean.TRUE.equals(this.header.use_zmm)) {
                record.peak_contingency_use_mb = Math.max(0, record.peak - record.heap_committed_non_pause_mb);
                record.after_gc_contingency_use_mb = Math.max(0, record.used_after_gc_mb - record.heap_committed_non_pause_mb);
            }
            try {
                record.reason_code = ReasonCodes.valueOf(record.label).toID();
            }
            catch (IllegalArgumentException ex) {
                record.reason_code = ReasonCodes.Unknown.toID();
            }
            double record_end = Math.max(record.end_old_logs, record.end);
            record.endTimestamp = record_end > 0.0 ? RelativeTimestamp.of(record_end, TimeUnit.SECONDS) : RelativeTimestamp.of(record.pause4_start + record.pause4_duration, TimeUnit.SECONDS);
            cpuUsageStatsMap.get(record.getGCType()).forEach(u -> u.process(record));
            SysinfoRecord lastSysinfoRecord = Optional.ofNullable(this.state.getLastRecordOfType(SysinfoRecord.class)).orElseGet(SysinfoRecord::new);
            record.native_heap_estimate_mb = Math.min(lastSysinfoRecord.cg_mem_total_rss_bytes / 0x100000L, (long)record.off_heap_committed_mb);
        }

        @Override
        public void init_impl(Lookup lookup) {
            static_fields_initialized.set(false);
            this.header = lookup.lookup(C4_LogHeader.class);
            this.state = lookup.lookup(C4_ParserState.class);
            isCPUSharesDefined = false;
            cpuUsageStatsMap.clear();
        }
    }
}

