/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import java.util.concurrent.TimeUnit;

@C4_LogDataRecord(header_marker="HEAPCOMMITH", data_marker="HEAPCOMMIT")
@C4_FieldsDescription(file="c4/HeapCommitRecord")
public final class HeapCommitRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="heap(mb)", defaultUnits=LogUnits.MEGABYTES)
    public int heap_mb;
    @C4_GCLogRecordField(header="commit(mb)", defaultUnits=LogUnits.MEGABYTES)
    public int commit_mb;
    @C4_GCLogRecordField(header="commitTime(ms)", defaultUnits=LogUnits.MILLISECONDS)
    public double commit_ms;
    @C4_GCLogRecordField(header="uncommit(mb)", defaultUnits=LogUnits.MEGABYTES)
    public int uncommit_mb;
    @C4_GCLogRecordField(header="uncommitTime(ms)", defaultUnits=LogUnits.MILLISECONDS)
    public double uncommit_ms;
    @C4_GCLogRecordField(header="numDelays", defaultUnits=LogUnits.COUNT)
    public double num_delays;
    @C4_GCLogRecordField(header="avgDelay(ms)", defaultUnits=LogUnits.MILLISECONDS)
    public double avg_delay_ms;
    @C4_GCLogRecordField(header="maxDelay(ms)", defaultUnits=LogUnits.MILLISECONDS)
    public double max_delay_ms;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double end_s;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return RelativeTimestamp.of(this.end_s, TimeUnit.SECONDS);
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<HeapCommitRecord> {
        public Parser() {
            super(HeapCommitRecord.class);
        }
    }
}

