/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_DoubleHeaderDataParser;
import com.azul.log.parser.impl.c4.C4_ParserState;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.records.C4_LogHeader;
import com.azul.log.parser.impl.c4.records.GCRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openide.util.Lookup;

@C4_LogDataRecord(header_marker="GPGC-HH", data_marker="GPGC-H")
@C4_FieldsDescription(file="c4/HeuristicsRecord")
public final class HeuristicsRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="Model MB/sec#NewGen", defaultUnits=LogUnits.RATE_MBPS)
    public double new_gen_alloc_mb_per_sec;
    @C4_GCLogRecordField(header="Model MB/sec#OldGen", defaultUnits=LogUnits.RATE_MBPS)
    public double old_gen_alloc_mb_per_sec;
    @C4_GCLogRecordField(header="Model MB/sec#PermGen", defaultUnits=LogUnits.RATE_MBPS)
    public double perm_gen_alloc_mb_per_sec;
    @C4_GCLogRecordField(header="Model MB/sec#Direct", defaultUnits=LogUnits.RATE_MBPS)
    public double direct_memory_alloc_mb_per_sec;
    @C4_GCLogRecordField(header="KIDRate#KID/sec", defaultUnits=LogUnits.RATE_KIDSPS)
    public double klass_id_alloc_per_sec;
    @C4_GCLogRecordField(header="EstTime secs#NewGC", defaultUnits=LogUnits.SECONDS)
    public double estimated_new_gc_length_seconds;
    @C4_GCLogRecordField(header="EstTime secs#OldGC", defaultUnits=LogUnits.SECONDS)
    public double estimated_old_gc_length_seconds;
    @C4_GCLogRecordField(header="Throttled GC Threads EstTime secs#NewGC_Model1", defaultUnits=LogUnits.SECONDS)
    public double estimated_new_gc_model1_length_seconds;
    @C4_GCLogRecordField(header="Throttled GC Threads EstTime secs#OldGC_Model1", defaultUnits=LogUnits.SECONDS)
    public double estimated_old_gc_model1_length_seconds;
    @C4_GCLogRecordField(header="Throttled GC Threads EstTime secs#NewGC_Model2", defaultUnits=LogUnits.SECONDS)
    public double estimated_new_gc_model2_length_seconds;
    @C4_GCLogRecordField(header="Throttled GC Threads EstTime secs#OldGC_Model2", defaultUnits=LogUnits.SECONDS)
    public double estimated_old_gc_model2_length_seconds;
    @C4_GCLogRecordField(header="EstTime secs#NewGC1", defaultUnits=LogUnits.SECONDS, alias="estimated_new_gc_model1_length_seconds")
    public double estimated_new_gc_model1_length_seconds_old;
    @C4_GCLogRecordField(header="EstTime secs#OldGC1", defaultUnits=LogUnits.SECONDS, alias="estimated_old_gc_model1_length_seconds")
    public double estimated_old_gc_model1_length_seconds_old;
    @C4_GCLogRecordField(header="EstTime secs#NewGC2", defaultUnits=LogUnits.SECONDS, alias="estimated_new_gc_model2_length_seconds")
    public double estimated_new_gc_model2_length_seconds_old;
    @C4_GCLogRecordField(header="EstTime secs#OldGC2", defaultUnits=LogUnits.SECONDS, alias="estimated_old_gc_model2_length_seconds")
    public double estimated_old_gc_model2_length_seconds_old;
    @C4_GCLogRecordField(header="CPU EstTime secs#NewCPU", defaultUnits=LogUnits.SECONDS)
    public double estimated_new_gc_cpu_time_seconds;
    @C4_GCLogRecordField(header="CPU EstTime secs#OldCPU", defaultUnits=LogUnits.SECONDS)
    public double estimated_old_gc_cpu_time_seconds;
    @C4_GCLogRecordField(header="CPU EstTime secs#NewCPU_Model1", defaultUnits=LogUnits.SECONDS)
    public double estimated_new_gc_model1_cpu_time_seconds;
    @C4_GCLogRecordField(header="CPU EstTime secs#OldCPU_Model1", defaultUnits=LogUnits.SECONDS)
    public double estimated_old_gc_model1_cpu_time_seconds;
    @C4_GCLogRecordField(header="CPU EstTime secs#NewCPU_Model2", defaultUnits=LogUnits.SECONDS)
    public double estimated_new_gc_model2_cpu_time_seconds;
    @C4_GCLogRecordField(header="CPU EstTime secs#OldCPU_Model2", defaultUnits=LogUnits.SECONDS)
    public double estimated_old_gc_model2_cpu_time_seconds;
    @C4_GCLogRecordField(header="Pause EstTime secs#NewGC_pause1", defaultUnits=LogUnits.SECONDS)
    public double estimated_new_gc_pause1_time_seconds;
    @C4_GCLogRecordField(header="EstTime percent#NewGC_time", defaultUnits=LogUnits.PERCENT)
    public double estimated_new_gc_time_percent;
    @C4_GCLogRecordField(header="Sizes MB#New", defaultUnits=LogUnits.MEGABYTES)
    public int new_gen_used_mb;
    @C4_GCLogRecordField(header="Sizes MB#Old", defaultUnits=LogUnits.MEGABYTES)
    public int old_gen_used_mb;
    @C4_GCLogRecordField(header="Sizes MB#Perm", defaultUnits=LogUnits.MEGABYTES)
    public int perm_gen_used_mb;
    @C4_GCLogRecordField(header="Sizes MB#Direct", defaultUnits=LogUnits.MEGABYTES)
    public int direct_memory_used_mb;
    @C4_GCLogRecordField(header="KIDCount#KID", defaultUnits=LogUnits.KIDS)
    public int number_of_kids;
    @C4_GCLogRecordField(header="Target MB#Heap", defaultUnits=LogUnits.MEGABYTES)
    public int target_mb_heap;
    @C4_GCLogRecordField(header="Target MB#NewGen", defaultUnits=LogUnits.MEGABYTES)
    public int target_mb_new_gen;
    @C4_GCLogRecordField(header="Time(secs)#Time", defaultUnits=LogUnits.SECONDS)
    public double timestamp_secs;
    @C4_GCLogRecordField(header="Heuristic#ReasonCode")
    public int reason_code;
    @C4_GCLogRecordField(header="Heuristic#ReasonString")
    public String reason_string;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"new_gen_used_mb", "old_gen_used_mb", "perm_gen_used_mb"})
    public double calculated_free_heap;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"old_gen_alloc_mb_per_sec", "perm_gen_alloc_mb_per_sec", "estimated_new_gc_length_seconds", "estimated_old_gc_length_seconds"})
    public double calculated_future_oldGen_needed;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"calculated_free_heap", "calculated_future_oldGen_needed"})
    public double calculated_newGen_memory_available_for_allocations;
    @LogRecordCalculatedField(defaultUnits=LogUnits.SECONDS, deps={"calculated_newGen_memory_available_for_allocations", "new_gen_used_mb", "timestamp_secs"})
    public double estimated_time_to_outOfMemory_in_newGen;
    private RelativeTimestamp eventTimestamp = null;
    private static final Map<Integer, String> code_to_reason = new HashMap<Integer, String>();

    public static String getReasonForCode(int reason_code) {
        String result = code_to_reason.get(reason_code);
        return result == null ? "" : result.replaceAll("_", " ");
    }

    public static String[] getReasonLabels() {
        int max_reason = code_to_reason.keySet().stream().reduce(Integer::max).orElse(0);
        String[] labels = new String[max_reason];
        for (int i = 0; i < max_reason; ++i) {
            labels[i] = HeuristicsRecord.getReasonForCode(i);
        }
        return labels;
    }

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return this.eventTimestamp;
    }

    public static final class Parser
    extends C4_DoubleHeaderDataParser<HeuristicsRecord> {
        private static final String[] firstLineFixupMatrix = new String[]{"Model MB/sec                 : KIDRate : EstTime secs : Sizes MB            : KIDCount  : Time(secs) : Heuristic", "NewGen OldGen PermGen Direct : KID/sec : NewGC OldGC NewGC1 OldGC1 NewGC2 OldGC2 : New Old Perm Direct : KID       : Time       : ReasonCode ReasonString", "Model MB/sec                 : KIDRate : EstTime secs                            : Sizes MB            : KIDCount  : Time(secs) : Heuristic"};
        private boolean firstLine = true;
        private C4_LogHeader header;
        private C4_ParserState state;

        public Parser() {
            super(HeuristicsRecord.class);
        }

        @Override
        protected boolean parseHeaderImpl(String header) throws ParserException {
            return super.parseHeaderImpl(header.replace(".", " "));
        }

        @Override
        protected String[] getFirstLineFixupMatrix() {
            return firstLineFixupMatrix;
        }

        @Override
        protected void computeCalculatedFields(HeuristicsRecord record) {
            code_to_reason.put(record.reason_code, record.reason_string);
            double rate = Math.max(record.new_gen_alloc_mb_per_sec, 1.0E-6);
            if (this.firstLine) {
                rate = (double)record.new_gen_used_mb / record.timestamp_secs;
                this.firstLine = false;
            }
            record.calculated_future_oldGen_needed = (record.old_gen_alloc_mb_per_sec + record.perm_gen_alloc_mb_per_sec) * (record.estimated_new_gc_length_seconds + record.estimated_old_gc_length_seconds) * 200.0 / 100.0;
            if (this.header.java_heap_Xmx_mb != null) {
                GCRecord gcRecord = this.state.getLastRecordOfType(GCRecord.class);
                long internal_used = gcRecord == null ? 0L : (long)gcRecord.internal_used;
                record.calculated_free_heap = (long)(this.header.java_heap_Xmx_mb - this.header.javaSystemMax_mb) - internal_used - (long)record.new_gen_used_mb - (long)record.old_gen_used_mb - (long)record.perm_gen_used_mb;
                record.calculated_newGen_memory_available_for_allocations = record.calculated_free_heap - record.calculated_future_oldGen_needed;
                record.estimated_time_to_outOfMemory_in_newGen = record.calculated_newGen_memory_available_for_allocations / rate;
            }
            record.eventTimestamp = RelativeTimestamp.of(record.timestamp_secs, TimeUnit.SECONDS);
        }

        @Override
        public void init_impl(Lookup lookup) {
            this.firstLine = true;
            this.header = lookup.lookup(C4_LogHeader.class);
            this.state = lookup.lookup(C4_ParserState.class);
            code_to_reason.clear();
        }
    }
}

