/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.records.C4_LogHeader;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.util.concurrent.TimeUnit;
import org.openide.util.Lookup;

@C4_LogDataRecord(header_marker="HUGEPAGESTATH", data_marker="HUGEPAGESTAT")
@C4_FieldsDescription(file="c4/HugePageStatRecord")
public final class HugePageStatRecord
extends C4_LogRecord {
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"compact_stall"})
    @C4_GCLogRecordField(header="compact_stall", defaultUnits=LogUnits.COUNT)
    public long compact_stall;
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"compact_success"})
    @C4_GCLogRecordField(header="compact_success", defaultUnits=LogUnits.COUNT)
    public long compact_success;
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"compact_fail"})
    @C4_GCLogRecordField(header="compact_fail", defaultUnits=LogUnits.COUNT)
    public long compact_fail;
    @LogRecordCalculatedField(defaultUnits=LogUnits.COUNT, deps={"compact_pages_moved"})
    @C4_GCLogRecordField(header="compact_pages_moved", defaultUnits=LogUnits.COUNT)
    public long compact_pages_moved;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PAGES, deps={"thp_fault_alloc"})
    @C4_GCLogRecordField(header="thp_fault_alloc", defaultUnits=LogUnits.PAGES)
    public long thp_fault_alloc;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PAGES, deps={"thp_fault_fallback"})
    @C4_GCLogRecordField(header="thp_fault_fallback", defaultUnits=LogUnits.PAGES)
    public long thp_fault_fallback;
    @LogRecordCalculatedField(defaultUnits=LogUnits.PAGES, deps={"thp_file_alloc"})
    @C4_GCLogRecordField(header="thp_file_alloc", defaultUnits=LogUnits.PAGES)
    public long thp_file_alloc;
    @LogRecordCalculatedField(defaultUnits=LogUnits.KILOBYTES, deps={"anon_huge_pages"})
    @C4_GCLogRecordField(header="anon_huge_pages", defaultUnits=LogUnits.KILOBYTES)
    public long anon_huge_pages;
    @LogRecordCalculatedField(defaultUnits=LogUnits.KILOBYTES, deps={"shmem_pmd_mapped"})
    @C4_GCLogRecordField(header="shmem_pmd_mapped", defaultUnits=LogUnits.KILOBYTES)
    public long shmem_pmd_mapped;
    @LogRecordCalculatedField(defaultUnits=LogUnits.KILOBYTES, deps={"shmem_huge_pages"})
    @C4_GCLogRecordField(header="shmem_huge_pages", defaultUnits=LogUnits.KILOBYTES)
    public long shmem_huge_pages;
    @C4_GCLogRecordField(header="huge_pages_total", defaultUnits=LogUnits.PAGES)
    public long huge_pages_total_pages;
    @C4_GCLogRecordField(header="huge_pages_free", defaultUnits=LogUnits.PAGES)
    public long huge_pages_free_pages;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double end_s;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"huge_pages_total_pages"})
    public long huge_pages_total_mb;
    @LogRecordCalculatedField(defaultUnits=LogUnits.MEGABYTES, deps={"huge_pages_free_pages"})
    public long huge_pages_free_mb;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return RelativeTimestamp.of(this.end_s, TimeUnit.SECONDS);
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<HugePageStatRecord> {
        private C4_LogHeader header;
        private HugePageStatRecord baseRecord = null;
        private int hugepagesize_mb;

        public Parser() {
            super(HugePageStatRecord.class);
        }

        @Override
        protected void computeCalculatedFields(HugePageStatRecord record) {
            if (this.baseRecord == null) {
                this.baseRecord = new HugePageStatRecord();
                this.baseRecord.compact_stall = record.compact_stall;
                this.baseRecord.compact_success = record.compact_success;
                this.baseRecord.compact_fail = record.compact_fail;
                this.baseRecord.compact_pages_moved = record.compact_pages_moved;
                this.baseRecord.thp_fault_alloc = record.thp_fault_alloc;
                this.baseRecord.thp_fault_fallback = record.thp_fault_fallback;
                this.baseRecord.thp_file_alloc = record.thp_file_alloc;
                this.baseRecord.anon_huge_pages = record.anon_huge_pages;
                this.baseRecord.shmem_pmd_mapped = record.shmem_pmd_mapped;
                this.baseRecord.shmem_huge_pages = record.shmem_huge_pages;
                this.baseRecord.end_s = record.end_s;
                Integer hugepagesize_kb = this.header.hugepagesize_kb;
                if (hugepagesize_kb == null) {
                    hugepagesize_kb = 2048;
                }
                this.hugepagesize_mb = hugepagesize_kb >> 10;
            }
            record.compact_stall -= this.baseRecord.compact_stall;
            record.compact_success -= this.baseRecord.compact_success;
            record.compact_fail -= this.baseRecord.compact_fail;
            record.compact_pages_moved -= this.baseRecord.compact_pages_moved;
            record.thp_fault_alloc -= this.baseRecord.thp_fault_alloc;
            record.thp_fault_fallback -= this.baseRecord.thp_fault_fallback;
            record.thp_file_alloc -= this.baseRecord.thp_file_alloc;
            record.anon_huge_pages -= this.baseRecord.anon_huge_pages;
            record.shmem_pmd_mapped -= this.baseRecord.shmem_pmd_mapped;
            record.shmem_huge_pages -= this.baseRecord.shmem_huge_pages;
            record.huge_pages_total_mb = record.huge_pages_total_pages * (long)this.hugepagesize_mb;
            record.huge_pages_free_mb = record.huge_pages_free_pages * (long)this.hugepagesize_mb;
        }

        @Override
        public void init_impl(Lookup lookup) {
            this.baseRecord = null;
            this.header = lookup.lookup(C4_LogHeader.class);
        }
    }
}

