/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.records;

import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.c4.C4_LogParser;
import com.azul.log.parser.impl.c4.C4_ParserState;
import com.azul.log.parser.impl.c4.C4_SingleHeaderDataParser;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.impl.c4.annotations.C4_LogDataRecord;
import com.azul.log.parser.impl.c4.records.GCRecord;
import com.azul.log.parser.impl.c4.spi.C4_LogLineParser;
import com.azul.log.parser.impl.c4.spi.C4_LogRecord;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.openide.util.Lookup;

@C4_LogDataRecord(header_marker="OBJCREATH", data_marker="OBJCREAT")
@C4_FieldsDescription(file="c4/ObjcreatRecord")
public final class ObjcreatRecord
extends C4_LogRecord {
    @C4_GCLogRecordField(header="newGen(kB)", defaultUnits=LogUnits.KILOBYTES)
    public double newGen_kb;
    @C4_GCLogRecordField(header="oldGen(kB)", defaultUnits=LogUnits.KILOBYTES)
    public double oldGen_kb;
    @C4_GCLogRecordField(header="permGen(kB)", defaultUnits=LogUnits.KILOBYTES)
    public double permGen_kb;
    @C4_GCLogRecordField(header="end(s)", defaultUnits=LogUnits.SECONDS)
    public double end_s;
    @LogRecordCalculatedField(defaultUnits=LogUnits.RATE_MBPS, deps={"newGen_kb"})
    public double newGen_mbs;
    @LogRecordCalculatedField(defaultUnits=LogUnits.RATE_MBPS, deps={"oldGen_kb"})
    public double oldGen_mbs;
    @LogRecordCalculatedField(defaultUnits=LogUnits.RATE_MBPS, deps={"permGen_kb"})
    public double permGen_mbs;
    private static ObjcreatRecord last = null;
    private static boolean skipNextRecordAfterOldGC = true;
    private RelativeTimestamp eventTimestamp = null;

    @Override
    public RelativeTimestamp getEventRelativeTimestampEx() {
        return this.eventTimestamp;
    }

    public static final class Parser
    extends C4_SingleHeaderDataParser<ObjcreatRecord> {
        public Parser() {
            super(ObjcreatRecord.class);
        }

        @Override
        protected C4_LogLineParser.DataLineParseResult parseDataLineImpl(C4_ParserState state, C4_LogParser.DataLine dataLine) throws ParserException {
            GCRecord lastGCRecord = state.getLastRecordOfType(GCRecord.class);
            if (Objects.nonNull(lastGCRecord) && lastGCRecord.isOld() && skipNextRecordAfterOldGC) {
                skipNextRecordAfterOldGC = false;
                return C4_LogLineParser.DataLineParseResult.DUMMY_RESULT;
            }
            skipNextRecordAfterOldGC = true;
            return super.parseDataLineImpl(state, dataLine);
        }

        @Override
        protected void computeCalculatedFields(ObjcreatRecord record) {
            if (last != null) {
                double time = record.end_s - ObjcreatRecord.last.end_s;
                record.newGen_mbs = (record.newGen_kb - ObjcreatRecord.last.newGen_kb) / 1024.0 / time;
                record.oldGen_mbs = (record.oldGen_kb - ObjcreatRecord.last.oldGen_kb) / 1024.0 / time;
                record.permGen_mbs = (record.permGen_kb - ObjcreatRecord.last.permGen_kb) / 1024.0 / time;
            } else {
                record.newGen_mbs = record.newGen_kb / 1024.0 / record.end_s;
                record.oldGen_mbs = record.oldGen_kb / 1024.0 / record.end_s;
                record.permGen_mbs = record.permGen_kb / 1024.0 / record.end_s;
            }
            record.eventTimestamp = RelativeTimestamp.of(record.end_s, TimeUnit.SECONDS);
            last = record;
        }

        @Override
        public void init_impl(Lookup lookup) {
            last = null;
        }
    }
}

