/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.spi;

import com.azul.log.model.api.LogRecord;
import com.azul.log.parser.impl.c4.annotations.C4_FieldsDescription;
import com.azul.log.parser.impl.c4.annotations.C4_GCLogRecordField;
import com.azul.log.parser.spi.annotations.LogRecordCalculatedField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class C4_LogRecord
extends LogRecord {
    @Override
    protected boolean isPrimaryField(Field field) {
        return field.getAnnotation(C4_GCLogRecordField.class) != null;
    }

    @Override
    protected List<String> getFieldNotes(Field field) {
        ArrayList<String> result = new ArrayList<String>();
        List fields = this.getDerivedFromFields(field).stream().map(this::getFieldName).collect(Collectors.toList());
        if (!fields.isEmpty()) {
            result.add("Calculated field. Depends on: " + String.join((CharSequence)", ", fields));
        }
        result.addAll(super.getFieldNotes(field));
        return result;
    }

    @Override
    protected Set<Field> getDerivedFromFields(Field field) {
        LogRecordCalculatedField annotation = field.getAnnotation(LogRecordCalculatedField.class);
        if (annotation != null) {
            String[] deps = annotation.deps();
            return Arrays.stream(deps).map(n -> {
                try {
                    return this.getClass().getField((String)n);
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    Logger.getLogger(C4_LogRecord.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    protected String getFieldShortDescription(Field field) {
        ResourceBundle bundle;
        C4_FieldsDescription annotation = this.getClass().getAnnotation(C4_FieldsDescription.class);
        if (annotation != null && !annotation.file().isEmpty() && (bundle = ResourceBundle.getBundle("descriptions/" + annotation.file(), Locale.getDefault())) != null) {
            String description;
            String key = field.getName();
            int idx = key.indexOf("_oldfmt");
            if (idx > 0) {
                key = key.substring(0, idx);
            }
            if (bundle.containsKey(key) && !(description = bundle.getString(key).trim()).isEmpty()) {
                return description;
            }
        }
        return super.getFieldShortDescription(field);
    }

    @Override
    protected String getFieldSpec(Field field) {
        return field.isAnnotationPresent(C4_GCLogRecordField.class) ? "%{" + field.getAnnotation(C4_GCLogRecordField.class).header() + "}" : null;
    }
}

