/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.c4.utils;

public final class C4_Utilities {
    private static final WordsList words = new WordsList(100);

    private C4_Utilities() {
    }

    public static WordsList splitWords(CharSequence string) {
        int word_start = 0;
        boolean inWord = false;
        words.clear();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (!inWord) continue;
                words.add(string.subSequence(word_start, i));
                inWord = false;
                continue;
            }
            if (c == ':') {
                if (inWord) {
                    words.add(string.subSequence(word_start, i));
                }
                words.add(":");
                inWord = false;
                word_start = i + 1;
                continue;
            }
            if (inWord) continue;
            inWord = true;
            word_start = i;
        }
        if (inWord) {
            words.add(string.subSequence(word_start, string.length()));
        }
        return words;
    }

    public static int countWords(CharSequence string) {
        int count = 0;
        boolean inWord = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case ' ': {
                    inWord = false;
                    continue block4;
                }
                case ':': {
                    inWord = false;
                    ++count;
                    continue block4;
                }
                default: {
                    if (inWord) continue block4;
                    inWord = true;
                    ++count;
                }
            }
        }
        return count;
    }

    public static class WordsList {
        private CharSequence[] words;
        private int size;
        private int limit;

        public WordsList(int initialLimit) {
            this.limit = initialLimit;
            this.words = new CharSequence[this.limit];
            this.size = 0;
        }

        public void clear() {
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public CharSequence get(int idx) {
            return this.words[idx];
        }

        public void add(CharSequence word) {
            if (this.size == this.limit) {
                this.limit *= 2;
                CharSequence[] new_words = new CharSequence[this.limit];
                System.arraycopy(this.words, 0, new_words, 0, this.size);
                this.words = new_words;
            }
            this.words[this.size++] = word;
        }
    }
}

