/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.metrics;

import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.api.LogLineWithTime;
import com.azul.log.parser.api.ParserException;
import com.azul.log.parser.impl.LogLineParser;
import com.azul.log.parser.impl.metrics.Metrics_ParserState;
import com.azul.log.parser.impl.metrics.Metrics_ParserSupport;
import com.azul.log.parser.spi.LogParserImpl;
import com.azul.log.parser.utils.TextUtils;
import com.azul.log.utils.ThrowingFunction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class Metrics_Parser
extends LogParserImpl<Metrics_ParserState> {
    private static final String TIMESTAMP = "timestamp";
    private static final String TIME_DATE = "time(date)";
    private static final String TIME = "time";
    private LogLineParser<Metrics_Record, Metrics_ParserState> recordParser;
    private ThrowingFunction<CharSequence, List<Metrics_Record>, ParserException> lineParser = this::parseHeader;
    private TimestampFormat timestampFormat;
    private int timestampDelimiter = 0;
    private AbsoluteTimestamp ts = null;

    Metrics_Parser(LogModel model) {
        super(model, new Metrics_ParserState());
    }

    private List<Metrics_Record> parseHeader(CharSequence line) throws ParserException {
        String header = line.toString();
        String[] columns = header.split(",");
        String c0 = columns[0].toLowerCase().replaceAll("[^(A-Za-z0-9_)]", "");
        if (TIMESTAMP.equals(c0)) {
            this.timestampFormat = TimestampFormat.GUESS;
        } else if (TIME_DATE.equals(c0)) {
            this.timestampFormat = TimestampFormat.DATE;
        } else if (c0.startsWith(TIMESTAMP)) {
            String format = c0.substring(c0.indexOf(40) + 1, c0.indexOf(41));
            this.timestampFormat = Arrays.stream(TimestampFormat.values()).filter(f -> f.identifier.equals(format)).findAny().orElseThrow(() -> new ParserException("Unknown timestamp format"));
        } else if (c0.equals(TIME)) {
            this.timestampFormat = TimestampFormat.TIME;
        } else {
            throw new ParserException("This is not a metrics file");
        }
        this.recordParser = Metrics_ParserSupport.generateMetricsRecordClass(columns);
        this.lineParser = this::parseData;
        return null;
    }

    private List<Metrics_Record> parseData(CharSequence dataChunk) throws ParserException {
        return this.recordParser.parseDataChunk(dataChunk);
    }

    @Override
    protected LogLineWithTime parseLogLineImpl(CharSequence line) throws ParserException {
        if (this.timestampFormat == null) {
            return new LogLineWithTime(line);
        }
        if (this.timestampDelimiter < 0 || line.length() <= this.timestampDelimiter || line.charAt(this.timestampDelimiter) != ',') {
            this.timestampDelimiter = TextUtils.indexOf(line, ',', 0);
            if (this.timestampDelimiter < 0) {
                return null;
            }
        }
        String timestamp = TextUtils.trim(line.subSequence(0, this.timestampDelimiter)).toString();
        if (this.timestampFormat == TimestampFormat.GUESS) {
            this.timestampFormat = this.guessTimestampFormat(timestamp);
        }
        AbsoluteTimestamp absoluteTimestamp = null;
        RelativeTimestamp relativeTimestamp = null;
        switch (this.timestampFormat) {
            case DATE: {
                try {
                    absoluteTimestamp = AbsoluteTimestamp.parse(timestamp);
                    break;
                }
                catch (ParseException e) {
                    return new LogLineWithTime(line);
                }
            }
            case TIME: 
            case EPOCH_MILLIS: {
                absoluteTimestamp = AbsoluteTimestamp.of((double)Long.parseLong(timestamp), LogUnits.MILLISECONDS);
                break;
            }
            case EPOCH_SEC: {
                absoluteTimestamp = AbsoluteTimestamp.of((double)Long.parseLong(timestamp), LogUnits.SECONDS);
                break;
            }
            case SECONDS: {
                relativeTimestamp = RelativeTimestamp.of(Double.parseDouble(timestamp), LogUnits.SECONDS);
                break;
            }
            default: {
                throw new InternalError("Unsupported timestampFormat");
            }
        }
        if (this.ts == null) {
            this.ts = absoluteTimestamp;
        }
        if (relativeTimestamp == null) {
            relativeTimestamp = RelativeTimestamp.delta(this.ts, absoluteTimestamp);
        }
        return new LogLineWithTime(absoluteTimestamp, relativeTimestamp, this.timestampDelimiter + 1, line);
    }

    private TimestampFormat guessTimestampFormat(String timestamp) throws ParserException {
        if (!timestamp.chars().allMatch(Character::isDigit)) {
            throw new ParserException("Unable to guess format of the timestamp " + timestamp);
        }
        int l = timestamp.length();
        return l > 10 ? TimestampFormat.EPOCH_MILLIS : (l > 5 ? TimestampFormat.EPOCH_SEC : TimestampFormat.SECONDS);
    }

    @Override
    protected List<Metrics_Record> getLogRecordsImpl(String data) {
        if (data.startsWith("#")) {
            return null;
        }
        return this.lineParser.apply(data);
    }

    public static class Metrics_Record
    extends LogRecord {
    }

    public static class Metrics_LogLineParser<T extends Metrics_Record>
    extends LogLineParser<T, Metrics_ParserState> {
        private final Field[] fields;
        private final Constructor<T> constructor;

        public Metrics_LogLineParser(Class<T> klass) {
            try {
                this.fields = klass.getDeclaredFields();
                this.constructor = klass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e);
            }
        }

        @Override
        public List<T> parseDataChunk(CharSequence dataChunk) throws ParserException {
            try {
                Metrics_Record record = (Metrics_Record)this.constructor.newInstance(new Object[0]);
                AtomicInteger fldIndex = new AtomicInteger();
                TextUtils.split(dataChunk, ',', data -> this.accessor.setFieldValueFromString(record, this.fields[fldIndex.getAndIncrement()], TextUtils.trim(data).toString()));
                return Collections.singletonList(record);
            }
            catch (Exception ex) {
                throw new ParserException(ex.getMessage());
            }
        }
    }

    private static enum TimestampFormat {
        GUESS(""),
        SECONDS("sec"),
        EPOCH_SEC("epoch"),
        EPOCH_MILLIS("epoch_ms"),
        DATE("date"),
        TIME("time");

        private final String identifier;

        private TimestampFormat(String identifier) {
            this.identifier = identifier;
        }
    }
}

