/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.impl.nmt;

import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.impl.nmt.records.NMT_MmapCommittedRecord;
import java.util.ArrayList;
import java.util.List;

public final class NMT_FieldTypes {
    private NMT_FieldTypes() {
    }

    public static final class CommittedList
    extends LogFieldTypes.LogFieldType {
        public final List<NMT_MmapCommittedRecord> list = new ArrayList<NMT_MmapCommittedRecord>();

        public int size() {
            return this.list.size();
        }

        public NMT_MmapCommittedRecord getRecord(int ind) {
            if (ind < 0 || ind >= this.list.size()) {
                return null;
            }
            return this.list.get(ind);
        }

        public String toString() {
            if (this.list.isEmpty()) {
                return "0";
            }
            String unit = "";
            String sample = this.list.get((int)0).size;
            if (sample.length() > 2) {
                unit = sample.substring(sample.length() - 2);
            }
            if (unit.matches("\\d+") || unit.isEmpty()) {
                return Integer.toString(this.list.stream().mapToInt(record -> Integer.parseInt(record.size)).sum());
            }
            int sumSize = this.list.stream().mapToInt(record -> Integer.parseInt(record.size.substring(0, record.size.length() - 2))).sum();
            return sumSize + unit;
        }
    }

    public static final class CallStack
    extends LogFieldTypes.LogFieldType {
        public final List<String> stack = new ArrayList<String>();

        public int size() {
            return this.stack.size();
        }

        public String getHTMLRepresentation() {
            StringBuilder sb = new StringBuilder();
            for (String str : this.stack) {
                sb.append("<br>&emsp;").append(str.replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
            }
            return sb.toString();
        }

        public String toString() {
            return "" + this.stack.size();
        }
    }
}

