/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.spi;

import com.azul.log.gctoolkitInterface.general.GCToolkitConnector;
import com.azul.log.gctoolkitInterface.general.GC_TYPE;
import com.microsoft.gctoolkit.jvm.JavaVirtualMachine;
import java.nio.file.Path;

public class GCTypeChecker {
    public static GC_TYPE identifyGCType(Path path) {
        JavaVirtualMachine jvm = GCToolkitConnector.initialize(path);
        GC_TYPE gcType = GC_TYPE.UNKNOWN;
        if (jvm.isG1GC()) {
            gcType = GC_TYPE.G1;
        } else if (jvm.isCMS()) {
            gcType = GC_TYPE.CMS;
        } else if (jvm.isZGC()) {
            gcType = GC_TYPE.ZGC;
        } else if (jvm.isShenandoah()) {
            gcType = GC_TYPE.SHENANDOAH;
        } else if (jvm.isParallel()) {
            gcType = GC_TYPE.PGC;
        } else if (jvm.isSerial()) {
            // empty if block
        }
        return gcType;
    }
}

