/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.spi;

import com.azul.log.parser.spi.LogParserImpl;
import com.azul.log.parser.spi.UserInteractionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.openide.util.Lookup;

public abstract class ParserFactory<T extends LogParserImpl<?>> {
    private final List<String[]> sets;
    private final Confidence confidence;
    private static final int MAX_FILE_LINES = 1000;

    public ParserFactory(Confidence confidence, String[] ... sets) {
        this.sets = new ArrayList(Arrays.asList(sets));
        this.confidence = confidence;
    }

    public static List<? extends ParserFactory<?>> getParserFactoriesFor(Path log) {
        List list;
        Set allExpectedLogLineMatches = Lookup.getDefault().lookupAll(ParserFactory.class).stream().map(x -> x.getSets()).flatMap(Collection::stream).flatMap(Arrays::stream).collect(Collectors.toSet());
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ArrayList malformedLines = new ArrayList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(log, new OpenOption[0]), decoder));
        try {
            AtomicInteger lineNumber = new AtomicInteger(0);
            List matchedLines = reader.lines().limit(1000L).peek(line -> {
                int currentLineNumber = lineNumber.incrementAndGet();
                if (line.contains("\ufffd")) {
                    malformedLines.add("line " + currentLineNumber + " : " + line);
                }
            }).filter(line -> allExpectedLogLineMatches.stream().anyMatch(line::contains)).collect(Collectors.toList());
            if (!malformedLines.isEmpty()) {
                StringBuilder errorMsg = new StringBuilder();
                malformedLines.stream().limit(3L).forEach(s -> errorMsg.append("\t").append((String)s).append("\n"));
                String errorMessage = String.format("Log file contains malformed characters on %d line(s), which may indicate a non-UTF-8 encoding.%nFirst few examples:%n%sTo continue, please either remove the problematic lines or correct the file's encoding to UTF-8.", malformedLines.size(), errorMsg);
                throw new MalformedLinesException(errorMessage);
            }
            Collection<ParserFactory> factories = Lookup.getDefault().lookupAll(ParserFactory.class);
            list = factories.stream().filter(f -> f.matches(matchedLines)).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return Collections.emptyList();
            }
        }
        reader.close();
        return list;
    }

    List<String[]> getSets() {
        return this.sets;
    }

    public final Confidence getConfidence() {
        return this.confidence;
    }

    protected boolean matches(List<String> lines) {
        ArrayList<String[]> toSearch = new ArrayList<String[]>(this.sets);
        for (String line : lines) {
            Iterator it = toSearch.iterator();
            while (it.hasNext()) {
                String[] set = (String[])it.next();
                if (!Arrays.stream(set).anyMatch(line::contains)) continue;
                it.remove();
                if (!toSearch.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public abstract T createParser(Path var1, UserInteractionHandler var2);

    private static final class MalformedLinesException
    extends RuntimeException {
        final String message;

        public MalformedLinesException(String message) {
            this.message = message;
        }

        @Override
        public String toString() {
            return this.message;
        }
    }

    public static enum Confidence {
        HIGH,
        LOW;

    }
}

