/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.support;

import com.azul.log.model.api.LogUnits;
import com.azul.log.parser.api.LogFieldTypes;
import com.azul.log.parser.utils.TextUtils;
import com.azul.log.parser.utils.spi.FieldSetterImplementation;
import com.azul.log.utils.ThrowingConsumer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openide.util.Lookup;

public final class FieldSetterSupport {
    private static final Map<Class<?>, FieldSetter> setters = FieldSetterSupport.initSetters();

    private FieldSetterSupport() {
    }

    public static FieldSetter getSetterFor(Class<?> type) {
        return setters.computeIfAbsent(type, t -> LogFieldTypes.LogFieldType.class.isAssignableFrom(type) ? setters.get(LogFieldTypes.LogFieldType.class) : (type.isEnum() ? EnumSetter.get(type) : null));
    }

    public static boolean setField(Object inst, Field field, CharSequence value) throws IllegalArgumentException {
        return Optional.ofNullable(FieldSetterSupport.getSetterFor(field.getType())).orElseThrow(() -> new IllegalArgumentException("No setter for " + field.getType().getName())).setField(inst, field, value, null);
    }

    private static <T> boolean s(CharSequence value, Function<CharSequence, T> parseImpl, ThrowingConsumer<T, Exception> setImpl) {
        T v = parseImpl.apply(value);
        if (v != null) {
            setImpl.accept(v);
            return true;
        }
        return false;
    }

    private static Map<Class<?>, FieldSetter> initSetters() {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseBoolean, r -> f.setBoolean(o, (boolean)r)));
        map.put(Character.TYPE, (o, f, v, u) -> FieldSetterSupport.s(v, t -> Character.valueOf(t.charAt(0)), r -> f.setChar(o, r.charValue())));
        map.put(Byte.TYPE, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseInt, r -> f.setByte(o, r.byteValue())));
        map.put(Short.TYPE, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseShort, r -> f.setShort(o, (short)r)));
        map.put(Integer.TYPE, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseInt, r -> f.setInt(o, (int)r)));
        map.put(Long.TYPE, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseLong, r -> f.setLong(o, (long)r)));
        map.put(Float.TYPE, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseFloat, r -> f.setFloat(o, r.floatValue())));
        map.put(Double.TYPE, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseDouble, r -> f.setDouble(o, (double)r)));
        map.put(Boolean.class, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseBoolean, r -> f.set(o, r)));
        map.put(Character.class, (o, f, v, u) -> FieldSetterSupport.s(v, t -> Character.valueOf(t.charAt(0)), r -> f.set(o, r)));
        map.put(Byte.class, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseInt, r -> f.set(o, r.byteValue())));
        map.put(Short.class, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseShort, r -> f.set(o, r)));
        map.put(Integer.class, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseInt, r -> f.set(o, r)));
        map.put(Long.class, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseLong, r -> f.set(o, r)));
        map.put(Float.class, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseFloat, r -> f.set(o, r)));
        map.put(Double.class, (o, f, v, u) -> FieldSetterSupport.s(v, TextUtils::parseDouble, r -> f.set(o, r)));
        map.put(String.class, (o, f, v, u) -> FieldSetterSupport.s(v, CharSequence::toString, r -> f.set(o, r)));
        Lookup.getDefault().lookupAll(FieldSetterImplementation.class).forEach(i -> map.put(i.getType(), i.getSetter()));
        map.put(LogFieldTypes.LogFieldType.class, (o, f, v, u) -> FieldSetterSupport.s(v, t -> LogFieldTypes.LogFieldType.parse(t.toString(), f.getType(), u), r -> f.set(o, r)));
        return map;
    }

    private static class EnumSetter<T extends Enum<T>>
    implements FieldSetter {
        private final Class<T> type;

        private EnumSetter(Class<T> type) {
            this.type = type;
        }

        public static <T extends Enum<T>> FieldSetter get(Class<T> type) {
            return new EnumSetter<T>(type);
        }

        @Override
        public boolean setField(Object i, Field f, CharSequence v, LogUnits defaultUnits) throws IllegalArgumentException {
            try {
                f.set(i, Enum.valueOf(this.type, v.toString().toUpperCase(Locale.US)));
                return true;
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Unable to parse " + this.type.getSimpleName());
            }
        }
    }

    public static interface FieldSetter {
        public boolean setField(Object var1, Field var2, CharSequence var3, LogUnits var4) throws IllegalArgumentException;
    }
}

