/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.support;

import com.azul.log.parser.support.SingleFileLogModel;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public abstract class SingleModifiableFileLogModel
extends SingleFileLogModel {
    private final Path modifiedFile;
    protected final String MODIFIED_FILE_SUFFIX = ".xlog";

    public SingleModifiableFileLogModel(String id, Path unmodifiedFile) {
        super(id, unmodifiedFile);
        this.modifiedFile = this.modifyFileIfNeeded(unmodifiedFile);
    }

    protected abstract Path modifyFile(Path var1);

    public boolean hasFailed() {
        return this.modifiedFile == null;
    }

    private Path modifyFileIfNeeded(Path unmodifiedFile) {
        if (unmodifiedFile.toString().endsWith(".xlog")) {
            return unmodifiedFile;
        }
        return this.modifyFile(unmodifiedFile);
    }

    @Override
    protected long calculateLogSize() throws IOException {
        return Files.size(this.modifiedFile);
    }

    @Override
    protected String calculateLogName() {
        return this.modifiedFile.getFileName().toString();
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return Files.newInputStream(this.modifiedFile, new OpenOption[0]);
    }

    @Override
    public List<Path> getPaths() {
        return Collections.singletonList(this.modifiedFile);
    }

    protected static final class FileUtils {
        protected FileUtils() {
        }

        public static PrintWriter getWriter(Path file) {
            try {
                return new PrintWriter((Writer)new FileWriter(file.toFile()), true);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Writing to file '%s' failed", file.getFileName()));
            }
        }
    }
}

