/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.support;

import com.azul.log.model.api.LogRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public abstract class SlidingWindowAggregator<R extends LogRecord> {
    protected final List<R> recordsInWindow = new ArrayList<R>();
    private final long windowDurationInMicros;
    private final BiConsumer<R, Double> recordUpdater;
    private double lastComputedValue;

    public SlidingWindowAggregator(long windowDurationInSec, BiConsumer<R, Double> recordUpdater) {
        this.windowDurationInMicros = TimeUnit.SECONDS.toMicros(windowDurationInSec);
        this.recordUpdater = recordUpdater;
    }

    public abstract double getComputedValue(R var1, R var2);

    public void process(R record) {
        LogRecord first;
        double deltaTime;
        if (!this.recordsInWindow.isEmpty() && (deltaTime = this.getDeltaTimeInMicros(first = (LogRecord)this.recordsInWindow.get(0), record)) > 0.0 && deltaTime >= (double)this.windowDurationInMicros) {
            this.lastComputedValue = this.getComputedValue(first, record);
            this.recordsInWindow.forEach(r -> this.updateRecordEntry(r, this.lastComputedValue));
            this.recordsInWindow.clear();
        }
        this.updateRecordEntry(record, this.lastComputedValue);
        this.recordsInWindow.add(record);
    }

    public double getDeltaTimeInMicros(R firstRecord, R secondRecord) {
        double first_ts = ((LogRecord)firstRecord).getEventRelativeTimestamp(TimeUnit.MICROSECONDS);
        double second_ts = ((LogRecord)secondRecord).getEventRelativeTimestamp(TimeUnit.MICROSECONDS);
        return second_ts - first_ts;
    }

    public void updateRecordEntry(R record, double computedValue) {
        this.recordUpdater.accept(record, computedValue);
    }

    public void reset() {
        this.recordsInWindow.clear();
        this.lastComputedValue = 0.0;
    }
}

