/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.parser.utils;

import com.azul.log.parser.spi.Destroyable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class Cache<K, V>
implements Destroyable {
    private final ReferenceQueue<V> queue = new ReferenceQueue();
    private final Map<K, WeakReference<V>> values;
    private final Map<WeakReference<V>, K> keys = Collections.synchronizedMap(new HashMap());
    private final Thread cleanupThread;

    private Cache(String id) {
        this.values = Collections.synchronizedMap(new HashMap());
        this.cleanupThread = new Thread("Cache cleanup thread: " + id){

            @Override
            public void run() {
                try {
                    while (true) {
                        WeakReference ref = (WeakReference)Cache.this.queue.remove();
                        Object key = Cache.this.keys.get(ref);
                        Cache.this.keys.remove(ref);
                        Cache.this.values.remove(key);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        this.cleanupThread.setDaemon(true);
    }

    public static <K, V> Cache<K, V> create(String id) {
        Cache<K, V> cache = new Cache<K, V>(id);
        cache.cleanupThread.start();
        return cache;
    }

    public V get(K key) {
        WeakReference<V> ref = this.values.get(key);
        return ref == null ? null : (V)ref.get();
    }

    public void put(K key, V value) {
        WeakReference<V> ref = new WeakReference<V>(value, this.queue);
        this.keys.put((WeakReference<K>)ref, (WeakReference<V>)key);
        this.values.put(key, ref);
    }

    public V computeIfAbsent(K key, Function<K, V> comp) {
        V result = this.get(key);
        if (result == null && (result = comp.apply(key)) != null) {
            this.put(key, result);
        }
        return result;
    }

    @Override
    public void destroy() {
        this.cleanupThread.interrupt();
        this.keys.clear();
        this.values.clear();
    }
}

