/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.ui.impl.nmt;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverter;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverterProvider;
import com.azul.log.parser.impl.nmt.NMT_Summary;

public class NMT_SummaryConverterProvider
implements LogSummaryToUIModelConverterProvider {
    @Override
    public boolean canCreateConverter() {
        return Context.lookup(NMT_Summary.class) != null;
    }

    @Override
    public LogSummaryToUIModelConverter createConverter() {
        return new Converter();
    }

    private static class Converter
    extends LogSummaryToUIModelConverter {
        private final NMT_Summary summary = Context.lookup(NMT_Summary.class);

        @Override
        protected void convertImpl(LogSummaryToUIModelConverter.Callback callback) {
            callback.addSection("Total Statistics");
            callback.addValue("Total", this.summary.totalMem);
            callback.addValueIfPresent("Malloc", this.summary.totalMalloc);
            callback.addValueIfPresent("Mmap", this.summary.totalMmap);
            callback.addSection("Java Heap");
            callback.addValue("Total", this.summary.heapMem);
            callback.addValue("Mmap", this.summary.heapMmap);
            callback.addSection("Class");
            callback.addValue("Total", this.summary.classMem);
            callback.addValue("Classes", this.summary.classNum);
            callback.addValueIfPresent("Class Data", this.summary.classData);
            callback.addValue("Malloc", this.summary.classMalloc);
            callback.addValueIfPresent("Mmap", this.summary.classMmap);
            callback.addSection("Thread");
            callback.addValue("Total", this.summary.threadMem);
            callback.addValue("Thread", this.summary.threadNum);
            callback.addValue("Stack", this.summary.threadStack);
            callback.addValue("Malloc", this.summary.threadMalloc);
            callback.addValue("Arena", this.summary.threadArena);
            callback.addSection("Code");
            callback.addValue("Total", this.summary.codeMem);
            callback.addValue("Malloc", this.summary.codeMalloc);
            callback.addValue("Mmap", this.summary.codeMmap);
            callback.addSection("Garbage Collector");
            callback.addValue("Total", this.summary.gcMem);
            callback.addValue("Malloc", this.summary.gcMalloc);
            callback.addValue("Mmap", this.summary.gcMmap);
            callback.addSection("Compiler");
            callback.addValue("Total", this.summary.compilerMem);
            callback.addValue("Malloc", this.summary.compilerMalloc);
            callback.addValue("Arena", this.summary.compilerArena);
            callback.addSection("Internal");
            callback.addValue("Total", this.summary.internalMem);
            callback.addValue("Malloc", this.summary.internalMalloc);
            callback.addValue("Mmap", this.summary.internalMmap);
            callback.addSection("Other");
            callback.addValueIfPresent("Total", this.summary.otherMem);
            callback.addValueIfPresent("Malloc", this.summary.otherMalloc);
            callback.addSection("Symbol");
            callback.addValue("Total", this.summary.symbolMem);
            callback.addValue("Malloc", this.summary.symbolMalloc);
            callback.addValueIfPresent("Arena", this.summary.symbolArena);
            callback.addSection("Native Memory Tracking");
            callback.addValue("Total", this.summary.nmtMem);
            callback.addValue("Malloc", this.summary.nmtMalloc);
            callback.addValue("Tracking Overhead", this.summary.nmtOverhead);
            callback.addSection("Arena Chunk");
            callback.addValue("Total", this.summary.arenaMem);
            callback.addValue("Malloc", this.summary.arenaMalloc);
            callback.addSection("Tracing");
            callback.addValueIfPresent("Total", this.summary.tracingMem);
            callback.addValueIfPresent("Malloc", this.summary.tracingMalloc);
            callback.addSection("Logging");
            callback.addValueIfPresent("Total", this.summary.loggingMem);
            callback.addValueIfPresent("Malloc", this.summary.loggingMalloc);
            callback.addSection("Arguments");
            callback.addValueIfPresent("Total", this.summary.argumentsMem);
            callback.addValueIfPresent("Malloc", this.summary.argumentsMalloc);
            callback.addSection("Module");
            callback.addValueIfPresent("Total", this.summary.otherMem);
            callback.addValueIfPresent("Malloc", this.summary.otherMalloc);
            callback.addSection("Synchronization");
            callback.addValueIfPresent("Total", this.summary.syncMem);
            callback.addValueIfPresent("Malloc", this.summary.syncMalloc);
        }
    }
}

