/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.utils;

import com.azul.log.utils.ProgressModel;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.CancellationException;

public class ProgressMonitorInputStream
extends FilterInputStream {
    private final ProgressModel progress;
    private final long size;

    public ProgressMonitorInputStream(ProgressModel progress, InputStream in, long size) {
        super(in);
        this.progress = progress;
        this.size = size;
        progress.setMaximum(size);
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            try {
                this.progress.addProgress(1L);
            }
            catch (CancellationException ex) {
                throw new InterruptedIOException();
            }
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            try {
                this.progress.addProgress(nr);
            }
            catch (CancellationException ex) {
                throw new InterruptedIOException();
            }
        }
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            try {
                this.progress.addProgress(nr);
            }
            catch (CancellationException ex) {
                throw new InterruptedIOException();
            }
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            try {
                this.progress.addProgress(nr);
            }
            catch (CancellationException ex) {
                throw new InterruptedIOException();
            }
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.progress.setProgress(this.progress.getMaximum());
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        try {
            this.progress.setProgress(this.size - (long)this.in.available());
        }
        catch (CancellationException ex) {
            throw new InterruptedIOException();
        }
    }
}

