/*
 * Decompiled with CFR 0.152.
 */
package com.azul.loganalyzer.cli;

import com.azul.log.parser.support.FieldSetterSupport;
import com.azul.loganalyzer.cli.ArgsParam;
import com.azul.loganalyzer.cli.ArgsSwitch;
import com.azul.loganalyzer.cli.ArgumentException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommandLineArguments {
    private final String help;
    private final String jarName;
    private final String[] commandLine;
    private final List<String> commandLineOptions;

    public CommandLineArguments(String[] commandLine, String jarName, String helpResource) {
        this.commandLine = Arrays.copyOf(commandLine, commandLine.length);
        this.jarName = jarName;
        this.help = helpResource;
        this.commandLineOptions = new ArrayList<String>();
    }

    protected abstract void validate(List<String> var1) throws ArgumentException;

    public List<String> getCommandLine() {
        return Collections.unmodifiableList(Arrays.asList(this.commandLine));
    }

    public List<String> getCommandLineOptions() {
        return Collections.unmodifiableList(this.commandLineOptions);
    }

    public final void parse() throws ArgumentException {
        Object param2;
        Field[] fields;
        HashMap<String, Field> paramsMap = new HashMap<String, Field>();
        HashMap<String, Field> switchesMap = new HashMap<String, Field>();
        HashSet<Field> requiredFields = new HashSet<Field>();
        for (Field fld2 : fields = this.getClass().getDeclaredFields()) {
            param2 = fld2.getAnnotation(ArgsParam.class);
            if (param2 != null) {
                for (String key : param2.keys()) {
                    paramsMap.put(key, fld2);
                }
                if (param2.isOptional()) continue;
                requiredFields.add(fld2);
                continue;
            }
            ArgsSwitch argSwitch = fld2.getAnnotation(ArgsSwitch.class);
            if (argSwitch == null) continue;
            for (String key : argSwitch.keys()) {
                switchesMap.put(key, fld2);
            }
        }
        ArrayList<String> remaining = new ArrayList<String>();
        for (int i = 0; i < this.commandLine.length; ++i) {
            String arg = this.commandLine[i];
            Field sw = (Field)switchesMap.get(arg);
            if (sw != null) {
                try {
                    sw.set(this, Boolean.TRUE);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw new ArgumentException(ex.getMessage());
                }
                this.commandLineOptions.add(arg);
                continue;
            }
            param2 = (Field)paramsMap.get(arg);
            if (param2 != null) {
                if (++i == this.commandLine.length) {
                    throw new ArgumentException("Parameter " + arg + " requires an argument");
                }
                if ("?".equals(this.commandLine[i])) {
                    this.printParamUsage((Field)param2);
                    System.exit(0);
                }
                try {
                    FieldSetterSupport.setField(this, (Field)param2, this.commandLine[i]);
                    requiredFields.remove(param2);
                    this.commandLineOptions.add(arg);
                    this.commandLineOptions.add(this.commandLine[i]);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    String fmt = "Error processing '%s %s'. Run with '%s ?' to get list of supported values.";
                    throw new ArgumentException(String.format(fmt, arg, this.commandLine[i], arg));
                }
            }
            remaining.add(arg);
        }
        this.validate(remaining);
        if (!requiredFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("You need to specify following parameters:\n");
            requiredFields.stream().map(fld -> fld.getAnnotation(ArgsParam.class)).filter(Objects::nonNull).forEach(param -> {
                for (String key : param.keys()) {
                    sb.append(key).append('|');
                }
                sb.setLength(sb.length() - 1);
                sb.append(' ').append(param.param());
                sb.append('\t').append(param.help());
                sb.append('\n');
            });
            throw new ArgumentException(sb.toString());
        }
    }

    public String getCommandLineOptionsHelpLine() {
        StringBuilder sb = new StringBuilder();
        for (Field fld : this.getClass().getDeclaredFields()) {
            ArgsParam param = fld.getAnnotation(ArgsParam.class);
            if (param != null) {
                if (param.isOptional()) {
                    sb.append('[');
                }
                for (String key : param.keys()) {
                    sb.append(key).append('|');
                }
                sb.setLength(sb.length() - 1);
                sb.append(' ');
                sb.append(param.param());
                if (param.isOptional()) {
                    sb.append(']');
                }
                sb.append(' ');
                continue;
            }
            ArgsSwitch sw = fld.getAnnotation(ArgsSwitch.class);
            if (sw == null) continue;
            sb.append('[');
            for (String key : sw.keys()) {
                sb.append(key).append('|');
            }
            sb.setLength(sb.length() - 1);
            sb.append("] ");
        }
        return sb.toString();
    }

    public void printParamUsage(Field fld) {
        ArgsParam ap = fld.getAnnotation(ArgsParam.class);
        System.out.print(ap.keys()[0] + " <" + ap.param() + ">: ");
        System.out.println(ap.help());
        Class<?> type = fld.getType();
        if (type.isEnum()) {
            System.out.println("\nFollowing values for the parameter are supported (case-insensitive):");
            Class<?> c = type;
            try {
                Enum[] constants = (Enum[])c.getEnumConstants();
                Arrays.sort(constants, (o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
                for (Enum ec : constants) {
                    String descr = this.describeEnumConstant(ec);
                    if (descr == null) continue;
                    System.out.printf("\t%-30s - %s\n", ec.name().toLowerCase(), descr);
                }
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(CommandLineArguments.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected String describeEnumConstant(Enum<?> value) {
        return null;
    }

    public void printUsage() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream(this.help)), Charset.defaultCharset()));){
            br.lines().map(l -> l.replaceAll("@JAR@", this.jarName)).forEach(System.out::println);
        }
        catch (IOException ex) {
            Logger.getLogger(CommandLineArguments.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

