/*
 * Decompiled with CFR 0.152.
 */
package com.azul.loganalyzer.cli.dump.json;

import com.azul.log.parser.api.LogFieldTypes;
import com.azul.loganalyzer.cli.dump.json.JSONSerializable;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;

public interface JSONWriter
extends Closeable {
    public static JSONWriter compact(OutputStream out) {
        return new Compact(out);
    }

    public static JSONWriter formatted(OutputStream out) {
        return new Formatted(out);
    }

    public void println(String var1);

    public void dumpObject(String var1, Object var2);

    public void startArray(String var1);

    public void endArray();

    public void startObject(String var1);

    public void endObject();

    public static abstract class JSONWriterImpl
    implements JSONWriter {
        private final PrintWriter writer;
        private String pline = null;

        private JSONWriterImpl(OutputStream out) {
            this.writer = new PrintWriter(out);
        }

        protected void print(String line) {
            this.writer.print(line);
        }

        protected void indent_right() {
            if (this.pline != null) {
                this.print(this.pline);
                this.pline = null;
            }
        }

        protected void indent_left() {
            if (this.pline != null && !this.pline.isEmpty()) {
                if (this.pline.charAt(this.pline.length() - 1) == ',') {
                    this.pline = this.pline.substring(0, this.pline.length() - 1);
                }
                this.print(this.pline);
                this.pline = null;
            }
        }

        @Override
        public void println(String line) {
            if (this.pline != null) {
                this.print(this.pline);
            }
            this.pline = line;
        }

        @Override
        public void close() {
            this.indent_left();
            this.writer.println("}");
            this.writer.close();
        }

        @Override
        public final void startObject(String name) {
            if (name != null) {
                this.println("\"" + name + "\":{");
            } else {
                this.println("{");
            }
            this.indent_right();
        }

        @Override
        public void endObject() {
            this.indent_left();
            this.println("},");
        }

        @Override
        public void startArray(String name) {
            if (name != null) {
                this.println("\"" + name + "\":[");
            } else {
                this.println("[");
            }
            this.indent_right();
        }

        @Override
        public void endArray() {
            this.indent_left();
            this.println("],");
        }

        @Override
        public void dumpObject(String name, Object obj) {
            Object n;
            if (obj == null) {
                return;
            }
            Object object = n = name == null ? "" : "\"" + name + "\":";
            if (obj instanceof String) {
                this.println((String)n + "\"" + ((String)obj).replace('\"', '\'') + "\",");
            } else if (obj instanceof Map) {
                Map map = (Map)obj;
                this.startArray(name);
                map.forEach((key, value) -> {
                    this.startObject(null);
                    this.dumpObject("n", key.toString());
                    this.dumpObject("v", value);
                    this.endObject();
                });
                this.endArray();
            } else if (obj instanceof JSONSerializable) {
                this.startObject(name);
                JSONSerializable js = (JSONSerializable)obj;
                js.dumpJSON(this);
                this.endObject();
            } else if (obj instanceof LogFieldTypes.Size) {
                this.println((String)n + ((LogFieldTypes.Size)obj).getBytes() + ",");
            } else if (obj.getClass().isArray()) {
                Object[] arr = (Object[])obj;
                this.startArray(name);
                for (Object entry : arr) {
                    this.dumpObject(null, entry);
                }
                this.endArray();
            } else {
                this.println((String)n + obj + ",");
            }
        }
    }

    public static final class Compact
    extends JSONWriterImpl {
        private Compact(OutputStream out) {
            super(out);
            this.startObject(null);
        }
    }

    public static final class Formatted
    extends JSONWriterImpl {
        private String indent = "";

        private Formatted(OutputStream out) {
            super(out);
            this.startObject(null);
        }

        @Override
        protected void print(String line) {
            if (line != null) {
                super.print(this.indent + line + "\n");
            }
        }

        @Override
        protected void indent_right() {
            super.indent_right();
            this.indent = this.indent + "  ";
        }

        @Override
        protected void indent_left() {
            super.indent_left();
            this.indent = this.indent.substring(2);
        }
    }
}

