/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.compile2xlog.impl;

import com.azul.jvm.compile.CompileRelated;
import com.azul.jvm.time.VmTime;
import com.azul.tools.compile2xlog.impl.LogWriter;
import java.util.Optional;
import java.util.stream.Stream;

public class CompileRelatedTransformer {
    private final String tag;
    private final LogWriter writer;
    private final String[] fields = new String[]{"tier", "compileId", "klass", "method", "signature", "byteCodeSize", "osr", "osrBci", "replacement", "synchronized_method", "exceptionHandler", "native_method", "wave", "stashFlavor", "methodId", "pmid", "klassId", "pkid", "score", "scoreUpdatedMs", "promoted", "generation", "compilerId", "optLevel"};

    public CompileRelatedTransformer(LogWriter writer, String tag, String ... extraFields) {
        this.writer = writer;
        this.tag = tag;
        String[] allFields = (String[])Stream.of(this.fields, extraFields == null ? new String[]{} : extraFields).flatMap(Stream::of).toArray(String[]::new);
        writer.writeHeader(tag, allFields);
    }

    protected final void emitValues(VmTime time, CompileRelated record, Object ... extraValues) {
        Object[] allValues = Stream.of({record.tier, record.compileId, record.method.className(), record.method.simpleName(), record.signature, Optional.ofNullable(record.bytes).map(Integer::intValue).orElse(-1), record.isOsr, Optional.ofNullable(record.osrBci).map(Integer::intValue).orElse(-1), record.isReplacement, record.isSynchronized, record.hasExceptionHandlers, record.isNative, Character.valueOf(record.waveTrigger.charValue()), Character.valueOf(record.stashFlavor.charValue()), Optional.ofNullable(record.methodId).map(Long::longValue).orElse(-1L), record.persistentMethodId.longValue(), Optional.ofNullable(record.klassId).map(Integer::intValue).orElse(-1), record.persistentKlassId.intValue(), Optional.ofNullable(record.score).map(Integer::intValue).orElse(0), Optional.ofNullable(record.scoreUpdated).map(Long::longValue).orElse(-1L), Optional.ofNullable(record.promoted).map(Integer::intValue).orElse(-1), Optional.ofNullable(record.generation).map(Integer::intValue).orElse(-1), record.compilerId.intValue(), record.optLevel}, extraValues == null ? new Object[]{} : extraValues).flatMap(Stream::of).toArray(Object[]::new);
        this.writer.writeLine(time, this.tag, allValues);
    }
}

