/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.compile2xlog.impl;

import com.azul.java.NameUtils;
import com.azul.jvm.MemoryAddress;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompileRelated;
import com.azul.jvm.deopts.UncommonTrap;
import com.azul.tools.compile2xlog.impl.CompileRelatedTransformer;
import com.azul.tools.compile2xlog.impl.LogWriter;
import java.util.Optional;
import java.util.function.Function;

public class UncommonTrapTransformer
extends CompileRelatedTransformer {
    private static final String TAG = "UNCOMMON_TRAP";
    private static final String REPACK_TAG = "REPACK";
    private final LogWriter writer;
    private final Function<CompilationId, CompileRelated> converter;

    public UncommonTrapTransformer(LogWriter writer, Function<CompilationId, CompileRelated> converter) {
        super(writer, TAG, "trapId", "reason", "reason_details", "action", "address", "thread");
        this.writer = writer;
        this.converter = converter;
        writer.writeHeader(REPACK_TAG, "compileId", "trapId", "klass", "method", "bci", "bytecode");
    }

    public void process(UncommonTrap trap) {
        CompileRelated compRecord;
        String trapReason = trap.reasonStr.replace(' ', '_');
        String trapReasonDetails = "N/A";
        if (trapReason.startsWith("unloaded(")) {
            trapReasonDetails = trapReason;
            trapReason = "unloaded";
        }
        if ((compRecord = this.converter.apply(trap.compileId)) == null) {
            System.out.println("NO COMPILATION RECORD FOR " + trap);
            return;
        }
        this.emitValues(trap.time, compRecord, new Object[]{trap.id.intValue(), trapReason, trapReasonDetails, trap.action, Optional.ofNullable(trap.address).map(MemoryAddress::longValue).orElse(0L), trap.thread.longValue()});
        for (UncommonTrap.Repack repack : trap.repacks) {
            this.writer.writeLine(trap.time, REPACK_TAG, new Object[]{trap.compileId.intValue(), trap.id.intValue(), NameUtils.classOf(repack.method), NameUtils.shortNameOf(repack.method), repack.bci.intValue(), repack.opcode});
        }
    }
}

