/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing;

import com.azul.gulp.io.IoProvider;
import com.azul.gulp.text.LineSource;
import com.azul.jvm.compile.CompileStarted;
import com.azul.jvm.deopts.UncommonTrap;
import com.azul.zing.ZingConsoleLog;
import com.azul.zing.ZingGcLog;
import com.azul.zing.ZingProfileLog;
import com.azul.zing.ZingTickLog;
import com.azul.zing.profilelog.ProfileHeader;
import com.azul.zing.zvrobot.ZVRobotDir;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;

public final class GulpZing {
    private GulpZing() {
    }

    public static ZingConsoleLog gulpConsole(String fileName) {
        return GulpZing.gulpConsole(new File(fileName));
    }

    public static ZingConsoleLog gulpConsole(File file) {
        return new ZingConsoleLog(new LineSource(file));
    }

    public static ZingConsoleLog gulpConsole(IoProvider<Reader> ioProvider) {
        return new ZingConsoleLog(new LineSource(ioProvider));
    }

    public static boolean isCompileLog(File file) {
        return GulpZing.isCompileLog(() -> new FileReader(file));
    }

    public static boolean isCompileLog(IoProvider<Reader> ioProvider) {
        ZingConsoleLog log = GulpZing.gulpConsole(ioProvider);
        return log.select(CompileStarted.class).first().isPresent() || log.select(UncommonTrap.class).first().isPresent();
    }

    public static ZingConsoleLog gulpXml(String fileName) {
        return GulpZing.gulpXml(new File(fileName));
    }

    public static ZingConsoleLog gulpXml(File file) {
        return GulpZing.gulpConsole(file);
    }

    public static ZingProfileLog gulpProfile(String fileName) {
        return GulpZing.gulpProfile(new File(fileName));
    }

    public static ZingProfileLog gulpProfile(File file) {
        return new ZingProfileLog(new LineSource(file));
    }

    public static ZingProfileLog gulpProfile(IoProvider<Reader> ioProvider) {
        return new ZingProfileLog(new LineSource(ioProvider));
    }

    public static boolean isProfileLog(File file) {
        return GulpZing.isProfileLog(() -> new FileReader(file));
    }

    public static boolean isProfileLog(IoProvider<Reader> ioProvider) {
        return GulpZing.gulpProfile(ioProvider).select(ProfileHeader.class).first().isPresent();
    }

    public static ZingGcLog gulpGc(String fileName) {
        return GulpZing.gulpGc(new File(fileName));
    }

    public static ZingGcLog gulpGc(File file) {
        return new ZingGcLog(new LineSource(file));
    }

    public static ZingTickLog gulpTickProfile(String zvrobotDir) {
        return GulpZing.gulpTickProfile(new File(zvrobotDir));
    }

    public static ZingTickLog gulpTickProfile(File zvrobotDir) {
        return new ZingTickLog(new ZVRobotDir(zvrobotDir));
    }
}

