/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.console.matchers;

import com.azul.gulp.text.Line;
import com.azul.gulp.text.RegexMatcher;
import com.azul.jvm.deopts.UncommonTrap;
import java.util.regex.Pattern;

class FrameRepackLineMatcher {
    private static final Pattern REPACK_REGEX = Pattern.compile("^\\s*\\[frame #\\d+\\]\\s+repack\\s+c(1|2):\\s+([\\w\\d\\.\\:\\$\\<\\>]*) @ bci (\\d+) bytecode\\(0x(.*?)\\)\\s*(?:\\(oldest frame\\))?$");

    FrameRepackLineMatcher() {
    }

    public static UncommonTrap.Repack match(Line line) {
        RegexMatcher matcher = line.match(REPACK_REGEX);
        if (matcher.matches()) {
            int bytecode;
            int compiler = matcher.nextInt();
            String method = matcher.nextString();
            int bci = matcher.nextInt();
            String bytecodeStr = matcher.nextString();
            if (bytecodeStr.contains("-")) {
                String[] parts = bytecodeStr.split("-", 2);
                bytecode = Integer.parseInt(parts[0].trim(), 16);
            } else {
                bytecode = Integer.parseInt(bytecodeStr, 16);
            }
            return new UncommonTrap.Repack(method, bci, bytecode);
        }
        return null;
    }

    public static boolean isLastLine(Line line) {
        return line.endsWith("(oldest frame)");
    }
}

