/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.console.matchers;

import com.azul.gulp.Emitter;
import com.azul.gulp.Gulp;
import com.azul.gulp.HandledMarker;
import com.azul.gulp.text.Line;
import com.azul.gulp.text.LineMatcher;
import com.azul.gulp.text.RegexMatcher;
import com.azul.java.MethodId;
import com.azul.jvm.MemoryAddress;
import com.azul.jvm.ThreadId;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.deopt.DeoptAction;
import com.azul.jvm.deopts.UncommonTrap;
import com.azul.zing.console.matchers.FrameRepackLineMatcher;
import com.azul.zing.console.matchers.ZephyrCompileLineParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class UncommonTrap202006LineMatcher
implements LineMatcher<UncommonTrap> {
    private static final Pattern IMMEDIATE_RECOMP_REGEX = Pattern.compile("^\\s*Immediately start recompiling while keeping method entrant after trap .* deopt_index = (.*)");
    @Gulp.Inject
    private HandledMarker<Line> lineMarker;
    private TrapInfo trapInfo;
    private boolean sawRepack;

    @Override
    public void process(Line line, Emitter<UncommonTrap> emitter) throws Exception {
        UncommonTrap.Repack repack;
        RegexMatcher matcher;
        if (this.trapInfo == null) {
            this.trapInfo = UncommonTrap202006LineMatcher.parseTrap(line);
            if (this.trapInfo != null) {
                this.lineMarker.mark(line);
                this.sawRepack = false;
            }
            return;
        }
        if (!this.sawRepack && (matcher = line.match(IMMEDIATE_RECOMP_REGEX)).matches()) {
            this.trapInfo.action = DeoptAction.REPLACEMENT_COMPILE;
            this.lineMarker.mark(line);
        }
        if ((repack = FrameRepackLineMatcher.match(line)) != null) {
            this.trapInfo.repacks.add(repack);
            this.lineMarker.mark(line);
            this.sawRepack = true;
            if (FrameRepackLineMatcher.isLastLine(line)) {
                this.fire(emitter);
            }
        }
    }

    private static TrapInfo parseTrap(Line line) {
        boolean osr;
        if (!line.contains("Uncommon trap #")) {
            return null;
        }
        TrapInfo trap = new TrapInfo();
        ZephyrCompileLineParser parser = new ZephyrCompileLineParser(line);
        try {
            trap.compileId = CompilationId.of(parser.readCompileId());
        }
        catch (NumberFormatException e) {
            return null;
        }
        try {
            parser.readFlag('s');
            parser.readFlag('!');
            parser.readFlag('b');
            osr = parser.readFlag('%');
            parser.readFlag();
            parser.readFlag();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        try {
            parser.readZingCompilerId();
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (!parser.matchesEventType("Uncommon trap")) {
            return null;
        }
        String idStr = parser.readStringToken();
        if (!idStr.startsWith("#")) {
            return null;
        }
        trap.id = Integer.parseInt(idStr.substring(1));
        parser.expect("occurred at");
        String addressStr = parser.readMetaInfoStart();
        trap.address = MemoryAddress.of(Long.parseLong(addressStr.substring(3), 16));
        parser.expectMetaInfoEnd();
        parser.expect("deopt_index =");
        trap.reason = parser.readStringToken();
        trap.method = parser.readMethod();
        parser.readSignature();
        if (osr) {
            parser.expect('@');
            parser.readBci();
        }
        while (parser.isMetaInfoStart()) {
            String metaStart;
            switch (metaStart = parser.readMetaInfoStart()) {
                case "tid": {
                    trap.thread = ThreadId.of(parser.readMetaLongValue());
                }
            }
            parser.consumeMetaInfo();
            parser.expectMetaInfoEnd();
        }
        return trap;
    }

    private void fire(Emitter<UncommonTrap> emitter) {
        emitter.fire(new UncommonTrap(this.trapInfo.id, MethodId.byNameOnly(this.trapInfo.method), this.trapInfo.address, this.trapInfo.thread, this.trapInfo.reason, this.trapInfo.compileId, this.trapInfo.action, this.trapInfo.repacks));
        this.trapInfo = null;
    }

    private static final class TrapInfo {
        int id;
        String method;
        MemoryAddress address;
        ThreadId thread;
        String reason;
        CompilationId compileId;
        DeoptAction action;
        List<UncommonTrap.Repack> repacks = new ArrayList<UncommonTrap.Repack>(10);

        private TrapInfo() {
        }
    }
}

